/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.release;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.projects.page.release.VersionReleaseStatusView;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class VersionView {
    @XmlElement
    private final String id;
    @XmlElement
    private final String name;
    @XmlElement
    private final String url;
    @XmlElement
    private final boolean released;
    @XmlElement
    private final boolean archived;
    @XmlElement
    private final Date startDate;
    @XmlElement
    private final Date releaseDate;
    @XmlElement
    private final String description;
    @XmlElement
    private final VersionReleaseStatusView status;
    @XmlElement
    private final List<Operation> operations;
    @XmlElement
    private final boolean overdue;

    public VersionView(Version version, String url, VersionReleaseStatusView status, Date startDate, Date releaseDate, boolean overdue, List<Operation> operations) {
        this.id = Long.toString(version.getId());
        this.name = version.getName();
        this.released = version.isReleased();
        this.archived = version.isArchived();
        this.description = StringUtils.stripToEmpty((String)version.getDescription());
        this.url = url;
        this.startDate = startDate;
        this.releaseDate = releaseDate;
        this.status = status;
        this.operations = operations;
        this.overdue = overdue;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReleased() {
        return this.released;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public String getDescription() {
        return this.description;
    }

    public VersionReleaseStatusView getStatus() {
        return this.status;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isOverdue() {
        return this.overdue;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VersionView)) {
            return false;
        }
        VersionView that = (VersionView)o;
        if (this.released != that.released) {
            return false;
        }
        if (this.archived != that.archived) {
            return false;
        }
        if (this.overdue != that.overdue) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        if (this.startDate != null ? !this.startDate.equals(that.startDate) : that.startDate != null) {
            return false;
        }
        if (this.releaseDate != null ? !this.releaseDate.equals(that.releaseDate) : that.releaseDate != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return this.operations != null ? this.operations.equals(that.operations) : that.operations == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.released ? 1 : 0);
        result = 31 * result + (this.archived ? 1 : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.releaseDate != null ? this.releaseDate.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.operations != null ? this.operations.hashCode() : 0);
        result = 31 * result + (this.overdue ? 1 : 0);
        return result;
    }

    @XmlRootElement
    public static class Operation {
        @XmlElement
        private final String href;
        @XmlElement
        private final String styleClass;
        @XmlElement
        private final String label;

        public Operation(String href, String styleClass, String label) {
            this.href = href;
            this.styleClass = styleClass;
            this.label = label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Operation)) {
                return false;
            }
            Operation operation = (Operation)o;
            if (this.href != null ? !this.href.equals(operation.href) : operation.href != null) {
                return false;
            }
            if (this.styleClass != null ? !this.styleClass.equals(operation.styleClass) : operation.styleClass != null) {
                return false;
            }
            return this.label != null ? this.label.equals(operation.label) : operation.label == null;
        }

        public int hashCode() {
            int result = this.href != null ? this.href.hashCode() : 0;
            result = 31 * result + (this.styleClass != null ? this.styleClass.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            return result;
        }

        public String getHref() {
            return this.href;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        public String getLabel() {
            return this.label;
        }
    }

    @XmlRootElement
    public static class Date {
        @XmlElement
        private final String formatted;
        @XmlElement
        private final String iso;
        @XmlElement
        private final String datePickerFormatted;

        public Date(String formatted, String iso, String datePickerFormatted) {
            this.formatted = formatted;
            this.iso = iso;
            this.datePickerFormatted = datePickerFormatted;
        }

        public String getDatePickerFormatted() {
            return this.datePickerFormatted;
        }

        public String getFormatted() {
            return this.formatted;
        }

        public String getIso() {
            return this.iso;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Date)) {
                return false;
            }
            Date date = (Date)o;
            if (this.formatted != null ? !this.formatted.equals(date.formatted) : date.formatted != null) {
                return false;
            }
            if (this.iso != null ? !this.iso.equals(date.iso) : date.iso != null) {
                return false;
            }
            return this.datePickerFormatted != null ? this.datePickerFormatted.equals(date.datePickerFormatted) : date.datePickerFormatted == null;
        }

        public int hashCode() {
            int result = this.formatted != null ? this.formatted.hashCode() : 0;
            result = 31 * result + (this.iso != null ? this.iso.hashCode() : 0);
            result = 31 * result + (this.datePickerFormatted != null ? this.datePickerFormatted.hashCode() : 0);
            return result;
        }
    }
}

