/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.components;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.ProjectService;
import com.atlassian.jira.projects.page.components.ComponentService;
import com.atlassian.jira.projects.page.components.ComponentToComponentViewTransformer;
import com.atlassian.jira.projects.page.components.ComponentView;
import com.atlassian.jira.projects.util.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import io.atlassian.fugue.Either;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="project/{projectKey}/component")
@Scanned
public class ComponentsResource {
    private final ComponentService componentService;
    private final ProjectService projectService;
    private final ProjectPermissions projectPermissions;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ComponentToComponentViewTransformer componentToComponentView;

    @Autowired
    public ComponentsResource(ComponentService componentService, ProjectService projectService, ProjectPermissions projectPermissions, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, ComponentToComponentViewTransformer componentToComponentViewTransformer) {
        this.componentService = componentService;
        this.projectService = projectService;
        this.projectPermissions = projectPermissions;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.componentToComponentView = componentToComponentViewTransformer;
    }

    @GET
    @Path(value="/{componentId}")
    public Response details(@PathParam(value="projectKey") String projectKey, @PathParam(value="componentId") Long componentId) {
        Either<ErrorCollection, Project> projectEither = this.projectService.getProject(projectKey);
        if (projectEither.isLeft()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Project project = (Project)projectEither.right().get();
        if (!this.projectPermissions.hasProjectAdminPermission(this.jiraAuthenticationContext.getLoggedInUser(), project).booleanValue()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Optional<ProjectComponent> projectComponent = this.componentService.getComponent(project, componentId);
        if (!projectComponent.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Function<ProjectComponent, ComponentView> projectComponentToComponentView = this.componentToComponentView.componentToComponentView(project);
        return Response.ok().entity(projectComponentToComponentView.apply((Object)projectComponent.get())).build();
    }
}

