/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.components;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentComparator;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.QueryHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import io.atlassian.fugue.Option;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ComponentService {
    private static final Logger log = LoggerFactory.getLogger(ComponentService.class);
    private final ProjectComponentManager projectComponentManager;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final com.atlassian.jira.projects.util.ProjectPermissions projectPermissions;

    @Autowired
    public ComponentService(@ComponentImport ProjectComponentManager projectComponentManager, @ComponentImport FieldVisibilityManager fieldVisibilityManager, QueryHelper queryHelper, UserFormats userFormats, @ComponentImport PermissionManager permissionManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, com.atlassian.jira.projects.util.ProjectPermissions projectPermissions) {
        this.projectComponentManager = projectComponentManager;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectPermissions = projectPermissions;
    }

    private boolean canViewComponents(Project project) {
        return this.projectPermissions.hasProjectAdminPermission(this.jiraAuthenticationContext.getLoggedInUser(), project) != false || this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, this.jiraAuthenticationContext.getLoggedInUser()) && !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(project.getId(), "components");
    }

    public Option<List<ProjectComponent>> getComponents(Project project) {
        if (this.canViewComponents(project)) {
            try {
                ImmutableList projectComponents = Ordering.from((Comparator)ProjectComponentComparator.INSTANCE).immutableSortedCopy((Iterable)this.projectComponentManager.findAllForProject(project.getId()));
                return Option.option((Object)projectComponents);
            }
            catch (DataAccessException e) {
                log.warn("Could not retrieve components for project: {}", (Object)project, (Object)e);
            }
        }
        return Option.none();
    }

    public Optional<ProjectComponent> getComponent(Project project, Long componentId) {
        if (this.canViewComponents(project)) {
            return Optional.ofNullable(this.projectComponentManager.getProjectComponent(componentId));
        }
        return Optional.empty();
    }
}

