/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.ProjectService;
import com.atlassian.jira.projects.api.sidebar.ProjectSidebarRenderer;
import com.atlassian.jira.projects.compatibility.AtlassianConnect;
import com.atlassian.jira.projects.page.ProjectPageVisitedEvent;
import com.atlassian.jira.projects.page.ProjectPanel;
import com.atlassian.jira.projects.page.ProjectWebPanelRenderer;
import com.atlassian.jira.projects.util.PageIdHasher;
import com.atlassian.jira.projects.util.TemplateRenderer;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectPageRenderer {
    public static final String MODULE_NAME = "com.atlassian.jira.jira-projects-plugin:project-page-soy";
    public static final String TEMPLATE_FOR_PAGE_WITH_SIDEBAR = "JIRA.Projects.Templates.page";
    public static final String TEMPLATE_FOR_PAGE_WITHOUT_SIDEBAR = "JIRA.Projects.Templates.pageContent";
    private final EventPublisher eventPublisher;
    private final ProjectService projectService;
    private final ProjectSidebarRenderer projectSidebarRenderer;
    private final ProjectWebPanelRenderer projectWebPanelRenderer;
    private final TemplateRenderer templateRenderer;
    private final PageIdHasher pageIdHasher;

    @Autowired
    public ProjectPageRenderer(@ComponentImport EventPublisher eventPublisher, ProjectService projectService, ProjectSidebarRenderer projectSidebarRenderer, ProjectWebPanelRenderer projectWebPanelRenderer, TemplateRenderer templateRenderer, PageIdHasher pageIdHasher) {
        this.eventPublisher = eventPublisher;
        this.projectService = projectService;
        this.projectSidebarRenderer = projectSidebarRenderer;
        this.projectWebPanelRenderer = projectWebPanelRenderer;
        this.templateRenderer = templateRenderer;
        this.pageIdHasher = pageIdHasher;
    }

    public Either<ErrorCollection, String> renderWithSidebar(String projectKey, String selectedItemId) {
        return this.render(projectKey, selectedItemId, true);
    }

    public Either<ErrorCollection, String> renderWithoutSidebar(String projectKey, String selectedItemId) {
        return this.render(projectKey, selectedItemId, false);
    }

    private Either<ErrorCollection, String> render(String projectKey, String selectedItemId, boolean includeSidebarHtml) {
        Either<ErrorCollection, Project> getProjectResult = this.projectService.getProject(projectKey);
        if (getProjectResult.isLeft()) {
            return Either.left((Object)getProjectResult.left().get());
        }
        Project project = (Project)getProjectResult.right().get();
        Option<ProjectPanel> webPanelContent = this.projectWebPanelRenderer.render(project, selectedItemId);
        if (webPanelContent.isEmpty()) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addReason(ErrorCollection.Reason.NOT_FOUND);
            return Either.left((Object)errors);
        }
        ProjectPanel projectPanel = (ProjectPanel)webPanelContent.get();
        String pageHtml = this.getPageHtml(includeSidebarHtml, project, selectedItemId, projectPanel);
        this.dispatchProjectVisitedEvent(selectedItemId);
        return Either.right((Object)pageHtml);
    }

    private void dispatchProjectVisitedEvent(String selectedItemId) {
        PageIdHasher.HashedId hashedId = this.pageIdHasher.generateId(selectedItemId);
        this.eventPublisher.publish((Object)new ProjectPageVisitedEvent(hashedId.getId(), hashedId.getPrefix()));
    }

    private String getPageHtml(boolean includeSidebarHtml, Project project, String selectedItemId, ProjectPanel projectPanel) {
        if (includeSidebarHtml) {
            String sidebarContent = this.projectSidebarRenderer.render(project, selectedItemId);
            ImmutableMap data = ImmutableMap.builder().put((Object)"content", (Object)projectPanel.getHtml()).put((Object)"sidebarContent", (Object)sidebarContent).put((Object)"windowTitle", (Object)project.getName()).put((Object)"containsHeader", (Object)(this.containsHeader(selectedItemId) || this.isConnectWebPanel(selectedItemId, projectPanel.getPanelType()) ? 1 : 0)).build();
            return this.templateRenderer.render(MODULE_NAME, TEMPLATE_FOR_PAGE_WITH_SIDEBAR, (Map<String, Object>)data);
        }
        return this.templateRenderer.render(MODULE_NAME, TEMPLATE_FOR_PAGE_WITHOUT_SIDEBAR, (Map<String, Object>)ImmutableMap.of((Object)"content", (Object)projectPanel.getHtml()));
    }

    private boolean isConnectWebPanel(String selectedItemId, ProjectPanel.PanelType panelType) {
        return AtlassianConnect.hasConnectPrefix(selectedItemId) && panelType == ProjectPanel.PanelType.WEB_PANEL;
    }

    private boolean containsHeader(String selectedItemId) {
        List<String> IDS_WITH_HEADER = Arrays.asList("com.atlassian.jira.jira-projects-plugin:summary-page", "com.atlassian.jira.jira-projects-plugin:release-page", "com.atlassian.jira.jira-projects-plugin:report-page", "com.atlassian.jira.jira-projects-plugin:components-page", "com.atlassian.jira.jira-projects-issue-navigator:sidebar-issue-navigator");
        return IDS_WITH_HEADER.contains(selectedItemId);
    }
}

