/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.impl;

import com.atlassian.jira.plugin.projectpanel.impl.AbstractProjectTabPanel;
import com.atlassian.jira.plugin.report.ReportModuleDescriptor;
import com.atlassian.jira.plugin.report.ReportModuleDescriptorComparators;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Scanned
public class ReportsProjectTabPanel
extends AbstractProjectTabPanel {
    private static final String CONTEXT_REPORTS_KEY = "reports";
    private final PluginAccessor pluginAccessor;

    public ReportsProjectTabPanel(@ComponentImport PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map params = super.createVelocityParams(ctx);
        params.put("reportsContext", ImmutableMap.of((Object)"project", (Object)ctx.getProject()));
        params.put(CONTEXT_REPORTS_KEY, this.getReports());
        return params;
    }

    public boolean showPanel(BrowseContext ctx) {
        return this.getReports().size() > 0;
    }

    @VisibleForTesting
    List<ReportModuleDescriptor> getReports() {
        ArrayList reports = new ArrayList(this.pluginAccessor.getEnabledModuleDescriptorsByClass(ReportModuleDescriptor.class));
        Predicate<ReportModuleDescriptor> visibleReportFilter = new Predicate<ReportModuleDescriptor>(){

            public boolean apply(ReportModuleDescriptor input) {
                return input.getModule().showReport();
            }
        };
        return Ordering.from((Comparator)ReportModuleDescriptorComparators.byName((Locale)this.authenticationContext.getLocale())).sortedCopy(Iterables.filter(reports, (Predicate)visibleReportFilter));
    }
}

