/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.fragment.impl;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlOrderByBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.ProjectTabPanelFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractUnresolvedIssuesFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractUrlFragmentUtil;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.JqlFactory;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.StatisticAccessorBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.SortOrder;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class UnresolvedIssuesByComponentFragment
extends AbstractUnresolvedIssuesFragment
implements ProjectTabPanelFragment {
    private static final Logger log = LoggerFactory.getLogger(UnresolvedIssuesByComponentFragment.class);
    private final ApplicationProperties applicationProperties;

    @Inject
    public UnresolvedIssuesByComponentFragment(@ComponentImport VelocityTemplatingEngine templatingEngine, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport FieldVisibilityManager fieldVisibilityManager, StatisticAccessorBeanFactory accessorBeanFactory, JqlFactory jqlFactory) {
        super(templatingEngine, authenticationContext, fieldVisibilityManager, accessorBeanFactory, jqlFactory);
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String getId() {
        return "unresolvedissuesbycomponent";
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        velocityParams.put("components", this.getComponents(ctx));
        velocityParams.put("urlUtil", new ComponentUrlUtil(this.getSearchRequest(ctx), this.authenticationContext.getLoggedInUser(), this.applicationProperties));
        return velocityParams;
    }

    @Override
    String getIssueFieldConstant() {
        return "components";
    }

    StatisticMapWrapper getComponents(BrowseContext ctx) {
        try {
            return this.getStatsBean(ctx).getAllFilterBy("components");
        }
        catch (SearchException e) {
            log.error("Could not search for priorities in project '{}'", (Object)ctx.getProject().getKey(), (Object)e);
            return null;
        }
    }

    public static class ComponentUrlUtil
    extends AbstractUrlFragmentUtil<ProjectComponent> {
        public ComponentUrlUtil(SearchRequest searchRequest, ApplicationUser user, ApplicationProperties applicationProperties) {
            super(searchRequest, user, applicationProperties);
        }

        @Override
        protected Clause getDomainClause(ProjectComponent component) {
            JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
            if (component != null) {
                builder.component().eq(component.getName());
            } else {
                builder.componentIsEmpty();
            }
            return builder.buildClause();
        }

        @Override
        protected OrderBy getOrderBy() {
            JqlOrderByBuilder jqlOrderByBuilder = JqlQueryBuilder.newOrderByBuilder();
            jqlOrderByBuilder.component(SortOrder.ASC);
            return jqlOrderByBuilder.buildOrderBy();
        }
    }
}

