/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.fragment.impl;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractIssuesFragment;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class DueIssuesFragment
extends AbstractIssuesFragment {
    private final FieldVisibilityManager fieldVisibilityManager;

    @Inject
    public DueIssuesFragment(@ComponentImport VelocityTemplatingEngine templatingEngine, @ComponentImport ApplicationProperties applicationProperites, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport SearchService searchService, @ComponentImport DateTimeFormatterFactory dateTimeFormatterFactory, @ComponentImport FieldVisibilityManager fieldVisibilityManager) {
        super(jiraAuthenticationContext, templatingEngine, searchService, applicationProperites, dateTimeFormatterFactory);
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    @Override
    public String getId() {
        return "dueissues";
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        return super.showFragment(ctx) && !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(ctx.getProject().getId(), "duedate");
    }

    @Override
    SearchRequest getSearchRequest(BrowseContext ctx) {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)ctx.createQuery());
        queryBuilder.where().defaultAnd().unresolved();
        queryBuilder.orderBy().clear().dueDate(SortOrder.ASC).priority(SortOrder.DESC).createdDate(SortOrder.ASC);
        return new SearchRequest(queryBuilder.buildQuery());
    }
}

