/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.badges;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.module.propertyset.PropertySet;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SidebarBadgesService {
    static final int MAX_COUNTER_VALUE = 3;
    private final UserPropertyManager propertyManager;
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    public SidebarBadgesService(@ComponentImport UserPropertyManager propertyManager, @ComponentImport JiraAuthenticationContext authenticationContext) {
        this.propertyManager = propertyManager;
        this.authenticationContext = authenticationContext;
    }

    public void incrementBadgeViewedCountFor(@Nonnull String sidebarNavItemId) {
        if (this.authenticationContext.isLoggedInUser()) {
            String badgeId = this.badgeIdFor(sidebarNavItemId);
            PropertySet propertySet = this.propertyManager.getPropertySet(this.authenticationContext.getUser());
            if (propertySet.exists(badgeId)) {
                int current = propertySet.getInt(badgeId);
                if (current < 3) {
                    propertySet.setInt(badgeId, current + 1);
                }
            } else {
                propertySet.setInt(badgeId, 0);
            }
        }
    }

    public boolean canDisplayBadgeFor(@Nonnull String sidebarNavItemId) {
        if (this.authenticationContext.isLoggedInUser()) {
            String badgeId = this.badgeIdFor(sidebarNavItemId);
            PropertySet propertySet = this.propertyManager.getPropertySet(this.authenticationContext.getUser());
            return !propertySet.exists(badgeId) || propertySet.getInt(badgeId) < 3;
        }
        return false;
    }

    public void discardBadgeFor(@Nonnull String sidebarNavItemId) {
        if (this.authenticationContext.isLoggedInUser()) {
            String badgeId = this.badgeIdFor(sidebarNavItemId);
            PropertySet propertySet = this.propertyManager.getPropertySet(this.authenticationContext.getUser());
            propertySet.setInt(badgeId, 3);
        }
    }

    private String badgeIdFor(String sidebarNavItemId) {
        return sidebarNavItemId + ".badge";
    }
}

