/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.agile;

import com.atlassian.jira.projects.agile.GlobalBoardContentRenderer;
import com.atlassian.jira.projects.agile.GlobalBoardHeaderRenderer;
import com.atlassian.jira.projects.agile.GlobalBoardSidebarRenderer;
import com.atlassian.jira.projects.api.sidebar.SidebarRenderer;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class GlobalBoardSidebarRendererImpl
implements GlobalBoardSidebarRenderer {
    private static final String GLOBAL_BOARD_ICON_WEBRESOURCE = "com.atlassian.jira.jira-projects-plugin:global-board-default-icon";
    private static final String GLOBAL_BOARD_ICON_NAME = "global-board.svg";
    private static final String IS_GLOBAL_SIDEBAR_WRM_KEY = "is-global-sidebar";
    private final GlobalBoardContentRenderer contentRenderer;
    private final GlobalBoardHeaderRenderer headerRenderer;
    private final SidebarRenderer sidebarRenderer;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final PageBuilderService pageBuilderService;

    @Autowired
    public GlobalBoardSidebarRendererImpl(GlobalBoardContentRenderer contentRenderer, GlobalBoardHeaderRenderer headerRenderer, SidebarRenderer sidebarRenderer, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, JiraPageBuilderService pageBuilderService) {
        this.contentRenderer = contentRenderer;
        this.headerRenderer = headerRenderer;
        this.sidebarRenderer = sidebarRenderer;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.pageBuilderService = pageBuilderService;
    }

    @Override
    public String render(Long id, String name, String selectedItemId) {
        String defaultAvatarUrl = this.webResourceUrlProvider.getStaticPluginResourceUrl(GLOBAL_BOARD_ICON_WEBRESOURCE, GLOBAL_BOARD_ICON_NAME, UrlMode.ABSOLUTE);
        return this.render(id, name, selectedItemId, defaultAvatarUrl);
    }

    @Override
    public String render(Long id, String name, String selectedItemId, String avatarUrl) {
        this.addGlobalSidebarFlagData();
        return this.sidebarRenderer.render(() -> this.contentRenderer.render(id, selectedItemId), () -> this.headerRenderer.render(name, avatarUrl), Option.none());
    }

    private void addGlobalSidebarFlagData() {
        this.pageBuilderService.assembler().data().requireData(IS_GLOBAL_SIDEBAR_WRM_KEY, Boolean.valueOf(true));
    }
}

