/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="QueryHelper")
public class QueryHelper {
    private static final Logger log = LoggerFactory.getLogger(QueryHelper.class);
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SearchService searchService;

    @Autowired
    public QueryHelper(@ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport SearchService searchService) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.searchService = searchService;
    }

    public String buildURL(Query query) {
        return SearchRequestViewUtils.getLink((SearchRequest)new SearchRequest(query), (String)this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl(), (ApplicationUser)this.jiraAuthenticationContext.getLoggedInUser());
    }

    public long countIssues(Query query) {
        try {
            return this.searchService.searchCount(this.jiraAuthenticationContext.getLoggedInUser(), query);
        }
        catch (SearchException e) {
            log.warn("Could not retrieve issues count for query '{}'", (Object)query, (Object)e);
            return 0L;
        }
    }
}

