/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="ProjectServiceWrapper")
public class ProjectService {
    private final JiraAuthenticationContext authenticationContext;
    private final com.atlassian.jira.bc.project.ProjectService projectService;

    @Autowired
    public ProjectService(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport com.atlassian.jira.bc.project.ProjectService projectService) {
        this.authenticationContext = authenticationContext;
        this.projectService = projectService;
    }

    public boolean currentUserCanAdministerProject(String key) {
        return this.projectService.getProjectByKeyForAction(this.authenticationContext.getUser(), key, ProjectAction.EDIT_PROJECT_CONFIG).isValid();
    }

    public Either<ErrorCollection, Project> getProject(String key) {
        ProjectService.GetProjectResult getProjectResult = this.projectService.getProjectByKey(this.authenticationContext.getUser(), key);
        return this.projectOrErrors(getProjectResult);
    }

    public Either<ErrorCollection, Project> getProject(long id) {
        ProjectService.GetProjectResult getProjectResult = this.projectService.getProjectById(this.authenticationContext.getUser(), Long.valueOf(id));
        return this.projectOrErrors(getProjectResult);
    }

    private Either<ErrorCollection, Project> projectOrErrors(ProjectService.GetProjectResult getProjectResult) {
        if (getProjectResult.isValid()) {
            return Either.right((Object)getProjectResult.getProject());
        }
        ErrorCollection errorCollection = getProjectResult.getErrorCollection();
        this.addAnonymityStatusForRedirect(errorCollection);
        return Either.left((Object)errorCollection);
    }

    private void addAnonymityStatusForRedirect(ErrorCollection errorCollection) {
        if (!this.authenticationContext.isLoggedInUser()) {
            errorCollection.addReason(ErrorCollection.Reason.NOT_LOGGED_IN);
        }
    }
}

