/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.web;

import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.plugin.componentpanel.ComponentTabPanel;
import com.atlassian.jira.plugin.componentpanel.ComponentTabPanelModuleDescriptor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.projects.legacy.componentpanel.BrowseComponentContextImpl;
import com.atlassian.jira.projects.web.BrowseProjectContextProvider;
import com.atlassian.jira.web.action.AbstractPluggableTabPanelAction;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class BrowseProjectComponent
extends AbstractPluggableTabPanelAction<ComponentTabPanelModuleDescriptor> {
    private final ProjectComponentManager projectComponentManager;
    private final PageBuilderService pageBuilderService;
    private final SearchService searchService;
    private final ProjectManager projectManager;
    private final BrowseProjectContextProvider browseProjectContextProvider;
    public static final String SUCCESS_TAB = "successtab";
    private Long componentId;
    private Long projectId;
    private boolean contentOnly;

    @Inject
    public BrowseProjectComponent(@ComponentImport ProjectComponentManager projectComponentManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport SearchService searchService, @ComponentImport ProjectManager projectManager, BrowseProjectContextProvider browseProjectContextProvider) {
        super(pluginAccessor);
        super.setPersistenceKey("jira.component.browser.selected");
        this.browseProjectContextProvider = browseProjectContextProvider;
        this.projectComponentManager = projectComponentManager;
        this.pageBuilderService = pageBuilderService;
        this.searchService = searchService;
        this.projectManager = projectManager;
    }

    protected String doExecute() {
        Project newProject;
        Project project = this.getSelectedProjectObject();
        if (this.projectId != null && (newProject = this.projectManager.getProjectObj(this.projectId)) != null && !newProject.equals(project)) {
            this.log.info((Object)"Specified project id to browse, but it is diff to current project.  Most prob a permission violation (or it doesn't exist)");
            return "permissionviolation";
        }
        if (project == null) {
            return this.getRedirect("/secure/BrowseProjects.jspa");
        }
        if (this.componentId != null) {
            ProjectComponent component = null;
            try {
                component = this.projectComponentManager.find(this.componentId);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
            if (component != null && component.getProjectId().equals(project.getId())) {
                this.pageBuilderService.assembler().resources().requireContext("jira.browse").requireContext("jira.browse.component");
                return this.contentOnly ? SUCCESS_TAB : "success";
            }
        }
        return this.getRedirect("/browse/" + project.getKey());
    }

    public Long getId() {
        return this.projectId;
    }

    public void setId(Long id) {
        this.projectId = id;
        this.setSelectedProjectId(id);
    }

    public void setComponentId(Long id) {
        this.componentId = id;
    }

    @ActionViewData
    public ProjectComponent getComponent() {
        try {
            return this.componentId == null ? null : this.projectComponentManager.find(this.componentId);
        }
        catch (EntityNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @ActionViewData
    public List<ComponentTabPanelModuleDescriptor> getComponentTabPanels() {
        return this.getTabPanels();
    }

    @ActionViewData
    public String getTabLabel() {
        boolean descriptorNoTitle;
        ComponentTabPanelModuleDescriptor tabPanel = (ComponentTabPanelModuleDescriptor)this.getSelectedTabPanel();
        boolean bl = descriptorNoTitle = tabPanel.getParams().containsKey("noTitle") && Boolean.parseBoolean((String)tabPanel.getParams().get("noTitle"));
        if (tabPanel != null && !descriptorNoTitle) {
            return tabPanel.getLabel();
        }
        if (tabPanel == null) {
            this.log.warn((Object)"Either unknown tab specified or no tab specified and no tabs in system");
        }
        return null;
    }

    @ActionViewData
    public String getTabHtml() throws IOException {
        ComponentTabPanelModuleDescriptor tabPanelDescriptor = (ComponentTabPanelModuleDescriptor)this.getSelectedTabPanel();
        if (tabPanelDescriptor == null) {
            this.log.warn((Object)("Unknown tab panel '" + this.getSelectedTab() + "' has been specified."));
            return "";
        }
        ComponentTabPanel panel = (ComponentTabPanel)tabPanelDescriptor.getModule();
        if (panel.showPanel((BrowseContext)this.getComponentContext())) {
            String tabHtml = panel.getHtml((BrowseContext)this.getComponentContext());
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append(tabHtml);
            return strBuilder.toString();
        }
        this.log.warn((Object)"Tab panel should be hidden.");
        return "";
    }

    @ActionViewData(value="success")
    public Map<String, Object> getContext() {
        return this.browseProjectContextProvider.getContext(this.getSelectedProjectObject(), this.getSelected());
    }

    protected List<ComponentTabPanelModuleDescriptor> getTabPanelModuleDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(ComponentTabPanelModuleDescriptor.class);
    }

    protected boolean isTabPanelHidden(ComponentTabPanelModuleDescriptor descriptor) throws PermissionException {
        return !((ComponentTabPanel)descriptor.getModule()).showPanel((BrowseContext)this.getComponentContext());
    }

    private BrowseComponentContextImpl getComponentContext() {
        return new BrowseComponentContextImpl(this.searchService, this.getComponent(), this.getLoggedInUser(), this.request);
    }

    public void setContentOnly(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }
}

