/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.servlet.component;

import com.atlassian.fugue.Option;
import com.atlassian.jira.projects.entity.ProjectPanelContext;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.model.WebPanel;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PanelRenderer {
    private final WebInterfaceManager webInterfaceManager;

    @Autowired
    public PanelRenderer(WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public Option<String> render(ProjectPanelContext projectPanelContext) {
        Map<String, Object> context = projectPanelContext.toMap();
        List panels = this.webInterfaceManager.getDisplayableWebPanels("jira-projects.panel", context);
        if (panels.size() > 0) {
            return Option.some((Object)this.renderPanels(context, panels));
        }
        return Option.none();
    }

    private String renderPanels(Map<String, Object> context, List<WebPanel> panels) {
        StringBuilder markup = new StringBuilder();
        for (WebPanel panel : panels) {
            markup.append(panel.getHtml(context));
        }
        return markup.toString();
    }
}

