/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.servlet;

import com.atlassian.fugue.Option;
import com.atlassian.jira.projects.entity.ProjectPanelContext;
import com.atlassian.jira.projects.servlet.page.ProjectPageRenderer;
import com.atlassian.jira.projects.util.ProjectPanelContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProjectPageServlet
extends HttpServlet {
    private static final String DARK_FEATURE_NAME = "com.atlassian.jira.projects.ProjectCentricNavigation";
    private final DarkFeatureManager darkFeatureManager;
    private final ProjectPageRenderer projectPageRenderer;
    private final ProjectPanelContextFactory projectPanelContextFactory;

    public ProjectPageServlet(@ComponentImport DarkFeatureManager darkFeatureManager, ProjectPageRenderer projectPageRenderer, ProjectPanelContextFactory projectPanelContextFactory) {
        this.darkFeatureManager = darkFeatureManager;
        this.projectPageRenderer = projectPageRenderer;
        this.projectPanelContextFactory = projectPanelContextFactory;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.darkFeatureManager.isFeatureEnabledForAllUsers(DARK_FEATURE_NAME)) {
            this.renderProjectPage(request, response);
        } else {
            response.sendError(404);
        }
    }

    private void renderProjectPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ProjectPanelContext context = this.projectPanelContextFactory.create((Option<String>)Option.option((Object)request.getPathInfo()));
        Option<String> markup = this.projectPageRenderer.render(context);
        if (markup.isDefined()) {
            response.getWriter().print((String)markup.get());
        } else {
            response.sendError(404);
        }
    }
}

