/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.fragment.impl;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlOrderByBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.ProjectTabPanelFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractUnresolvedIssuesFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractUrlFragmentUtil;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.SortOrder;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;

@Named
public class UnresolvedIssuesByFixVersionFragment
extends AbstractUnresolvedIssuesFragment
implements ProjectTabPanelFragment {
    private static final Logger log = Logger.getLogger(UnresolvedIssuesByFixVersionFragment.class);
    private final ApplicationProperties applicationProperties;

    @Inject
    public UnresolvedIssuesByFixVersionFragment(@ComponentImport VelocityTemplatingEngine templatingEngine, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport FieldVisibilityManager fieldVisibilityManager) {
        super(templatingEngine, jiraAuthenticationContext, fieldVisibilityManager);
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String getId() {
        return "unresolvedissuesbyfixversion";
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        velocityParams.put("versions", this.getVersions(ctx));
        velocityParams.put("urlUtil", new FixVersionUrlUtil(this.getSearchRequest(ctx), this.authenticationContext.getLoggedInUser(), this.applicationProperties));
        return velocityParams;
    }

    @Override
    String getIssueFieldConstant() {
        return "fixVersions";
    }

    StatisticMapWrapper getVersions(BrowseContext ctx) {
        try {
            return this.getStatsBean(ctx).getAllFilterBy("allFixfor");
        }
        catch (SearchException e) {
            log.error((Object)("Could not search for versions in project '" + ctx.getProject().getKey() + "'"), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        return !ctx.getProject().getVersions().isEmpty() && super.showFragment(ctx);
    }

    public static class FixVersionUrlUtil
    extends AbstractUrlFragmentUtil<Version> {
        public FixVersionUrlUtil(SearchRequest searchRequest, User user, ApplicationProperties applicationProperties) {
            super(searchRequest, user, applicationProperties);
        }

        @Override
        protected Clause getDomainClause(Version version) {
            JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
            if (version != null) {
                builder.fixVersion().eq(version.getName());
            } else {
                builder.fixVersionIsEmpty();
            }
            return builder.buildClause();
        }

        @Override
        protected OrderBy getOrderBy() {
            JqlOrderByBuilder jqlOrderByBuilder = JqlQueryBuilder.newOrderByBuilder();
            jqlOrderByBuilder.fixForVersion(SortOrder.ASC);
            return jqlOrderByBuilder.buildOrderBy();
        }
    }
}

