/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.componentpanel.fragment.impl;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.plugin.componentpanel.BrowseComponentContext;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.projects.legacy.componentpanel.fragment.ComponentTabPanelFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractFragment;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;

@Named
public class ComponentDescriptionFragment
extends AbstractFragment
implements ComponentTabPanelFragment {
    private static final String TEMPLATE_DIRECTORY_PATH = "legacy/templates/componentpanels/fragments/summary/";
    private final UserFormatManager userFormatManager;

    @Inject
    public ComponentDescriptionFragment(@ComponentImport VelocityTemplatingEngine templatingEngine, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport UserFormatManager userFormatManager) {
        super(templatingEngine, jiraAuthenticationContext);
        this.userFormatManager = userFormatManager;
    }

    @Override
    public String getId() {
        return "componentdescription";
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        try {
            ProjectComponent component = ((BrowseComponentContext)ctx).getComponent();
            return !StringUtils.isBlank((String)component.getDescription()) || component.getLead() != null;
        }
        catch (ClassCastException e) {
            log.error((Object)"The supplied context must be of type BrowseComponentContext", (Throwable)e);
            throw new IllegalArgumentException("The supplied context must be of type BrowseComponentContext", e);
        }
    }

    @Override
    protected String getTemplateDirectoryPath() {
        return TEMPLATE_DIRECTORY_PATH;
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        velocityParams.put("userFormatter", this.userFormatManager.getUserFormatter("profileLink"));
        return velocityParams;
    }
}

