/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.pinnablenavigator;

import com.atlassian.jira.pageobjects.util.TraceContext;
import com.atlassian.jira.pageobjects.util.Tracer;
import com.atlassian.jira.projects.pageobjects.webdriver.page.pinnablenavigator.ManageDialog;
import com.atlassian.jira.projects.pageobjects.webdriver.page.pinnablenavigator.Navigator;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementActions;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;

public abstract class AbstractNavigator
implements Navigator {
    @Inject
    private PageElementActions actions;
    @Inject
    private PageElementFinder pageElementFinder;
    @Inject
    private TraceContext traceContext;
    @Inject
    private PageBinder pageBinder;
    private final By navigatorSelector;

    public AbstractNavigator(By navigatorSelector) {
        this.navigatorSelector = navigatorSelector;
    }

    protected PageElement navigator() {
        return this.pageElementFinder.find(this.navigatorSelector);
    }

    @Override
    public List<String> getItemLabels() {
        return this.getItemLabels(this.navigator());
    }

    @Override
    public String getSelectedItemLabel() {
        return this.navigator().find(By.cssSelector((String)".aui-nav-selected .js-item-link")).getAttribute("title");
    }

    @Override
    public List<String> getItemLabelsForGroup(int index) {
        return this.getItemLabels(this.navigator().find(By.cssSelector((String)("ul:nth-of-type(" + index + ")"))));
    }

    @Override
    public Navigator selectItem(String label) {
        this.getElementByLabel(label).click();
        return this;
    }

    @Override
    public ManageDialog manage() {
        Tracer checkpoint = this.traceContext.checkpoint();
        PageElement navigator = this.navigator();
        this.actions.moveToElement(navigator).perform();
        navigator.find(By.className((String)"js-manage-button")).click();
        this.traceContext.waitFor(checkpoint, "jira.projects.manage.dialog.shown");
        return (ManageDialog)this.pageBinder.bind(ManageDialog.class, new Object[0]);
    }

    private PageElement getElementByLabel(String label) {
        return this.navigator().find(By.cssSelector((String)String.format(".js-item-link[title='%s']", label)));
    }

    private List<String> getItemLabels(PageElement target) {
        ArrayList items = Lists.newArrayList();
        List itemEls = target.findAll(By.className((String)"js-item-link"));
        for (PageElement item : itemEls) {
            items.add(item.getAttribute("title").trim());
        }
        return items;
    }
}

