/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.legacy;

import com.atlassian.jira.pageobjects.pages.AbstractJiraTabPage;
import com.atlassian.jira.projects.pageobjects.webdriver.page.legacy.BrowseProjectTab;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.openqa.selenium.By;

public class BrowseProjectPage
extends AbstractJiraTabPage<BrowseProjectTab> {
    public static final String URL = "/browse/%s";
    private final String projectKey;
    @ElementBy(className="project-details")
    private PageElement projectDetails;
    @ElementBy(id="project-admin-link")
    private PageElement adminLink;

    public BrowseProjectPage(String projectKey) {
        this.projectKey = projectKey;
    }

    public TimedCondition isAt() {
        return this.projectDetails.timed().isPresent();
    }

    public String getUrl() {
        return String.format(URL, this.projectKey);
    }

    public String getProjectName() {
        return this.projectDetails.find(By.tagName((String)"h1")).getText();
    }

    public TimedCondition hasAdminLink() {
        return this.adminLink.timed().isVisible();
    }

    public void goToAdmin() {
        Poller.waitUntilTrue((TimedQuery)this.hasAdminLink());
        this.adminLink.click();
    }

    protected <T extends BrowseProjectTab> Object[] argsForTab(Class<T> tabClass) {
        return new Object[]{this.projectKey};
    }

    public List<String> getBrowseProjectTabs() {
        List navLinks = this.elementFinder.findAll(By.className((String)"browse-tab"));
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)navLinks, (Function)new Function<PageElement, String>(){

            public String apply(PageElement input) {
                return input.getText();
            }
        }));
    }
}

