/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import org.openqa.selenium.By;

public class IssueStatusSummarySection {
    public static final String UNDEFINED = "undefined";
    public static final String TO_DO = "new";
    public static final String IN_PROGRESS = "indeterminate";
    public static final String COMPLETE = "done";
    @ElementBy(className="issue-status-summary")
    private PageElement issueStatusBar;
    @ElementBy(cssSelector=".status-category.background-yellow")
    private PageElement inProgressCategoryBarSegment;
    @ElementBy(cssSelector=".status-category.background-blue-gray")
    private PageElement todoCategoryBarSegment;
    @ElementBy(cssSelector=".status-category.background-green")
    private PageElement doneCategoryBarSegment;
    @ElementBy(cssSelector=".issue-summary-row.indeterminate")
    private PageElement inProgressSummary;
    @ElementBy(cssSelector=".issue-summary-row.new")
    private PageElement todoSummary;
    @ElementBy(cssSelector=".issue-summary-row.done")
    private PageElement doneSummary;
    @ElementBy(cssSelector=".issue-summary-row.undefined")
    private PageElement undefinedSummary;

    @WaitUntil
    public void ready() {
        Poller.waitUntilTrue((TimedQuery)this.issueStatusBar.timed().isVisible());
    }

    public boolean hasCategoryDone() {
        return this.doneCategoryBarSegment.isVisible();
    }

    public boolean hasCategoryToDo() {
        return this.todoCategoryBarSegment.isVisible();
    }

    public boolean hasCategoryInProgress() {
        return this.inProgressCategoryBarSegment.isVisible();
    }

    public StatusCategorySummary getDoneSummary() {
        return this.buildStatusCategorySummary(this.doneSummary);
    }

    public StatusCategorySummary getToDoSummary() {
        return this.buildStatusCategorySummary(this.todoSummary);
    }

    public StatusCategorySummary getInProgressSummary() {
        return this.buildStatusCategorySummary(this.inProgressSummary);
    }

    public StatusCategorySummary getUndefinedSummary() {
        return this.buildStatusCategorySummary(this.undefinedSummary);
    }

    private StatusCategorySummary buildStatusCategorySummary(PageElement summaryElement) {
        PageElement linkElement = summaryElement.find(By.tagName((String)"a"));
        PageElement issueCountLozenge = summaryElement.find(By.className((String)"issue-count-container"));
        return new StatusCategorySummary(linkElement.getText(), linkElement.getAttribute("href"), Long.parseLong(issueCountLozenge.getText()));
    }

    public static class StatusCategorySummary {
        private final String categoryName;
        private final String link;
        private final long numberOfIssues;

        public StatusCategorySummary(String categoryName, String link, long numberOfIssues) {
            this.categoryName = categoryName;
            this.link = link;
            this.numberOfIssues = numberOfIssues;
        }

        public String getCategoryName() {
            return this.categoryName;
        }

        public String getLink() {
            return this.link;
        }

        public long getNumberOfIssues() {
            return this.numberOfIssues;
        }
    }
}

