/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.func.rest;

import com.atlassian.jira.projects.pageobjects.func.rest.ProjectShortcutBean;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;

public class ShortcutsClient {
    private final ApacheHttpClient client;
    private final JIRAEnvironmentData environmentData;
    private final String projectKey;
    private final String username;
    private final String password;

    public ShortcutsClient(JIRAEnvironmentData environmentData, String projectKey, String username, String password) {
        this.environmentData = environmentData;
        this.projectKey = projectKey;
        this.username = username;
        this.password = password;
        DefaultApacheHttpClientConfig config = new DefaultApacheHttpClientConfig();
        config.getClasses().add(JacksonJaxbJsonProvider.class);
        this.client = ApacheHttpClient.create((ClientConfig)config);
    }

    public ShortcutsClient(JIRAEnvironmentData environmentData, String projectKey) {
        this(environmentData, projectKey, "admin", "admin");
    }

    public ShortcutsClient login(String username, String password) {
        return new ShortcutsClient(this.environmentData, this.projectKey, username, password);
    }

    public ShortcutsClient anonymous() {
        return new ShortcutsClient(this.environmentData, this.projectKey, null, null);
    }

    public ClientResponse create(ProjectShortcutBean bean) {
        return (ClientResponse)this.configure(this.mainResource()).post(ClientResponse.class, (Object)bean);
    }

    public ClientResponse update(Integer id, ProjectShortcutBean bean) {
        return (ClientResponse)this.configure(this.mainResource().path(id.toString())).put(ClientResponse.class, (Object)bean);
    }

    public ClientResponse getAll() {
        return (ClientResponse)this.configure(this.mainResource()).get(ClientResponse.class);
    }

    public ClientResponse get(Integer id) {
        return (ClientResponse)this.configure(this.mainResource().path(id.toString())).get(ClientResponse.class);
    }

    public ClientResponse delete(Integer id) {
        return (ClientResponse)this.configure(this.mainResource().path(id.toString())).delete(ClientResponse.class);
    }

    private WebResource.Builder configure(WebResource resource) {
        if (this.username != null) {
            resource.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username, this.password));
        }
        return (WebResource.Builder)resource.accept(new String[]{"application/json"}).type("application/json");
    }

    private WebResource mainResource() {
        return this.client.resource(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("projects").path("1.0").path("project").path(this.projectKey).path("shortcut");
    }
}

