/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.shortcuts;

import com.atlassian.jira.pageobjects.components.DropDown;
import com.atlassian.jira.pageobjects.util.TraceContext;
import com.atlassian.jira.pageobjects.util.Tracer;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.google.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public abstract class ShortcutDialog {
    private final String operationName;
    @Inject
    protected TraceContext traceContext;
    @Inject
    private PageElementFinder pageElementFinder;
    @Inject
    private PageBinder pageBinder;
    @ElementBy(cssSelector=".project-shortcuts-name input", within="rootElement")
    protected PageElement name;
    @ElementBy(cssSelector=".project-shortcuts-name .error", within="rootElement")
    protected PageElement nameErrors;
    @ElementBy(cssSelector=".project-shortcuts-url input", within="rootElement")
    protected PageElement url;
    @ElementBy(cssSelector=".project-shortcuts-url .error", within="rootElement")
    protected PageElement urlErrors;
    @ElementBy(className="project-shortcuts-icons-picker", within="rootElement")
    protected PageElement iconPicker;
    @ElementBy(className="project-shortcuts-submit", within="rootElement")
    protected PageElement submit;
    @ElementBy(className="project-shortcuts-cancel", within="rootElement")
    protected PageElement cancel;

    protected ShortcutDialog(String operationName) {
        this.operationName = operationName;
    }

    protected DropDown iconDropdown() {
        return (DropDown)this.pageBinder.bind(IconsDropdown.class, new Object[]{this.iconPicker});
    }

    protected PageElement iconsList() {
        return this.pageElementFinder.find(By.cssSelector((String)"body > .project-shortcuts-icons-list"));
    }

    public ShortcutDialog name(String name) {
        this.name.clear().type(new CharSequence[]{name});
        return this;
    }

    public ShortcutDialog url(String url) {
        this.url.clear().type(new CharSequence[]{url});
        return this;
    }

    public ShortcutDialog icon(String icon) {
        this.iconDropdown().openAndClick(By.cssSelector((String)String.format("[data-project-shortcuts-icons-id='%s']", icon)));
        return this;
    }

    public ShortcutDialog openIconPicker() {
        this.iconDropdown().open();
        return this;
    }

    public ShortcutDialog closeIconPicker() {
        this.iconDropdown().close();
        return this;
    }

    public ShortcutDialog clickActiveIcon() {
        this.iconDropdown().openAndClick(By.className((String)"active"));
        return this;
    }

    public ShortcutDialog typeOnIconPicker(Keys ... key) {
        this.iconDropdown().open();
        this.iconPicker.type((CharSequence[])key);
        return this;
    }

    public ShortcutDialog clearName() {
        this.name.clear();
        return this;
    }

    public ShortcutDialog clearUrl() {
        this.url.clear();
        return this;
    }

    public ShortcutDialog submit() {
        Tracer checkpoint = this.traceContext.checkpoint();
        this.submit.click();
        Poller.waitUntilFalse((TimedQuery)this.name.timed().isVisible());
        this.traceContext.waitFor(checkpoint, "jira.projects.shortcuts." + this.operationName + ".success");
        return this;
    }

    public ShortcutDialog submitExpectingErrors() {
        Tracer checkpoint = this.traceContext.checkpoint();
        this.submit.click();
        this.traceContext.waitFor(checkpoint, "jira.projects.shortcuts." + this.operationName + ".fail");
        return this;
    }

    @WaitUntil
    public TimedCondition isAt() {
        return this.name.timed().isVisible();
    }

    public TimedQuery<String> getNameError() {
        return this.nameErrors.timed().getText();
    }

    public TimedQuery<String> getUrlError() {
        return this.urlErrors.timed().getText();
    }

    public TimedQuery<String> getActiveIconOnPicker() {
        return this.iconsList().find(By.className((String)"active")).timed().getAttribute("data-project-shortcuts-icons-id");
    }

    public TimedCondition isPickerActive() {
        return this.iconsList().timed().isVisible();
    }

    public TimedCondition isPickerPresent() {
        return this.iconPicker.timed().isPresent();
    }

    public static class IconsDropdown
    extends DropDown {
        private final PageElement triggerElement;

        public IconsDropdown(PageElement triggerElement) {
            super(null, By.cssSelector((String)"body > .project-shortcuts-icons-list"));
            this.triggerElement = triggerElement;
        }

        protected PageElement trigger() {
            return this.triggerElement;
        }
    }
}

