/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar;

import com.atlassian.jira.pageobjects.framework.elements.ExtendedElementFinder;
import com.atlassian.jira.pageobjects.framework.util.TimedQueryFactory;
import com.atlassian.jira.pageobjects.util.TraceContext;
import com.atlassian.jira.pageobjects.util.Tracer;
import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.CollapsedScopeFilter;
import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.ScopeFilter;
import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.shortcuts.SidebarProjectShortcutsSection;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.openqa.selenium.By;

public class Sidebar {
    @Inject
    TimedQueryFactory timedQueryFactory;
    @Inject
    ExtendedElementFinder extendedElementFinder;
    @Inject
    private PageBinder pageBinder;
    @Inject
    private TraceContext traceContext;
    @Inject
    private PageElementFinder elementFinder;
    @ElementBy(cssSelector=".aui-sidebar.projects-sidebar")
    private PageElement sidebar;
    @ElementBy(cssSelector=".aui-sidebar.projects-sidebar .aui-sidebar-toggle")
    private PageElement sidebarToggle;
    @ElementBy(cssSelector=".aui-sidebar.sidebar-placeholder")
    private PageElement sidebarPlaceholder;
    @ElementBy(cssSelector=".aui-sidebar.projects-sidebar [href*='/plugins/servlet/project-config/']")
    private PageElement projectAdminLink;
    private final String projectKey;
    private final boolean waitForIt;

    public Sidebar(String projectKey) {
        this(projectKey, true);
    }

    public Sidebar(String projectKey, boolean waitForIt) {
        this.projectKey = projectKey;
        this.waitForIt = waitForIt;
    }

    public TimedCondition isPresent() {
        return this.sidebar.timed().isVisible();
    }

    public TimedCondition hasAdminLink() {
        return this.projectAdminLink.timed().isPresent();
    }

    public PageElement getProjectAdminLink() {
        return this.projectAdminLink;
    }

    @WaitUntil
    public void waitUntil() {
        if (this.waitForIt) {
            Poller.waitUntilFalse((TimedQuery)this.sidebarPlaceholder.timed().isPresent());
            Poller.waitUntilTrue((TimedQuery)this.sidebar.timed().isVisible());
        }
    }

    public Sidebar expandSidebar() {
        if (((Boolean)this.sidebarIsCollapsed().now()).booleanValue()) {
            this.toggleSidebar();
        }
        Poller.waitUntilFalse((TimedQuery)this.sidebarIsCollapsed());
        return this;
    }

    public ScopeFilter getScopeFilter() {
        if (!((Boolean)this.sidebarIsCollapsed().now()).booleanValue()) {
            throw new NotImplementedException("We have not yet implemented a page object to represent ScopeFilter in an expanded state.");
        }
        ScopeFilter scopeFilter = (ScopeFilter)this.pageBinder.bind(CollapsedScopeFilter.class, new Object[0]);
        return scopeFilter;
    }

    public Sidebar collapseSidebar() {
        if (!((Boolean)this.sidebarIsCollapsed().now()).booleanValue()) {
            this.toggleSidebar();
        }
        Poller.waitUntilTrue((TimedQuery)this.sidebarIsCollapsed());
        return this;
    }

    public TimedCondition sidebarIsCollapsed() {
        return this.sidebar.timed().hasAttribute("aria-expanded", "false");
    }

    private void toggleSidebar() {
        this.sidebarToggle.click();
    }

    public SidebarProjectShortcutsSection getShortcutsSection() {
        PageElement rootElement = (Boolean)this.sidebarIsCollapsed().now() != false ? this.elementFinder.find(By.cssSelector((String)"aui-inline-dialog .aui-sidebar-submenu")) : this.sidebar.find(By.className((String)"project-shortcuts-group"));
        return (SidebarProjectShortcutsSection)this.pageBinder.bind(SidebarProjectShortcutsSection.class, new Object[]{rootElement});
    }

    public SidebarLink getLinkByName(String name) {
        PageElement pageElement = this.getLinkElementByName(name);
        if (!pageElement.isPresent()) {
            pageElement = this.getLinkElementByName(this.getRenamedLinkName(name));
        }
        return (SidebarLink)this.pageBinder.bind(SidebarLink.class, new Object[]{pageElement});
    }

    public SidebarLink getLinkById(String id) {
        PageElement pageElement = this.getLinkElementById(id);
        return (SidebarLink)this.pageBinder.bind(SidebarLink.class, new Object[]{pageElement});
    }

    private PageElement getLinkElementByName(String name) {
        String xpath = "//span[text()=\"%s\" and @class=\"%s\"]/../..";
        return this.sidebar.find(By.xpath((String)String.format(xpath, name, "aui-nav-item-label")), TimeoutType.SLOW_PAGE_LOAD);
    }

    private PageElement getLinkElementById(String id) {
        String xpath = "//*[contains(@class, \"aui-sidebar\")]//a[@data-link-id=\"%s\"]/..";
        return this.sidebar.find(By.xpath((String)String.format(xpath, id)), TimeoutType.SLOW_PAGE_LOAD);
    }

    public TimedCondition hasLinkById(String id) {
        return Conditions.forSupplier(() -> this.getLinkElementById(id).isPresent());
    }

    public TimedQuery<Iterable<SidebarLink>> getAllSidebarLinks() {
        Supplier linksSupplier = this.extendedElementFinder.within((PageElementFinder)this.sidebar).newQuery(By.cssSelector((String)".aui-sidebar-group-tier-one .aui-nav li")).transform(e -> (SidebarLink)this.pageBinder.bind(SidebarLink.class, new Object[]{e})).supplier();
        return this.timedQueryFactory.forSupplier(linksSupplier);
    }

    private String getRenamedLinkName(String requestedName) {
        if ("Report".equals(requestedName)) {
            return "Reports";
        }
        if ("Reports".equals(requestedName)) {
            return "Report";
        }
        if ("Release".equals(requestedName)) {
            return "Releases";
        }
        if ("Releases".equals(requestedName)) {
            return "Release";
        }
        return requestedName;
    }

    public boolean isLoadedBeforeDCL(Tracer checkpoint) {
        this.traceContext.waitFor(checkpoint, "jira.projects.sidebar.init");
        List arguments = this.traceContext.getArguments(checkpoint, "jira.projects.sidebar.init");
        return arguments.size() >= 1 && ((Map)arguments.get(0)).get("dclFired") != Boolean.TRUE;
    }

    public static class SidebarLink {
        @Inject
        private PageBinder pageBinder;
        private final PageElement parentElement;
        private final PageElement linkElement;

        public SidebarLink(PageElement parentElement) {
            this.parentElement = parentElement;
            this.linkElement = parentElement.find(By.className((String)"aui-nav-item"));
        }

        public TimedCondition isVisible() {
            return this.linkElement.timed().isVisible();
        }

        public TimedCondition isPresent() {
            return this.linkElement.timed().isPresent();
        }

        public TimedCondition isSelected() {
            return this.parentElement.timed().hasClass("aui-nav-selected");
        }

        public TimedQuery<String> getUrl() {
            return this.linkElement.timed().getAttribute("href");
        }

        public TimedQuery<String> getLinkID() {
            return this.linkElement.timed().getAttribute("data-link-id");
        }

        public TimedQuery<String> getText() {
            return this.linkElement.timed().getText();
        }

        public <T> T click(Class<T> pageClass, Object ... args) {
            Poller.waitUntilTrue((TimedQuery)this.linkElement.timed().isPresent());
            this.linkElement.click();
            return (T)this.pageBinder.bind(pageClass, args);
        }

        public void toggleTwixi() {
            this.parentElement.find(By.className((String)"aui-nav-subtree-toggle")).click();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("text", this.getText().now()).append("linkID", this.getLinkID().now()).toString();
        }
    }
}

