/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.pinnablenavigator;

import com.atlassian.jira.projects.pageobjects.webdriver.page.pinnablenavigator.ManageDialog;
import com.atlassian.jira.projects.pageobjects.webdriver.page.pinnablenavigator.Navigator;
import com.atlassian.jira.projects.pageobjects.webdriver.page.pinnablenavigator.PinnedView;
import com.atlassian.jira.projects.pageobjects.webdriver.page.pinnablenavigator.UnpinnedView;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.google.common.base.Supplier;
import java.util.List;
import javax.inject.Inject;

public class PinnableNavigator
implements Navigator {
    @ElementBy(className="subnav-pinned")
    private PageElement pinnedNav;
    @ElementBy(className="subnav-trigger")
    private PageElement unpinnedNav;
    @Inject
    private PageBinder pageBinder;

    @WaitUntil
    public void isPresent() {
        Supplier<Boolean> supplier = new Supplier<Boolean>(){

            public Boolean get() {
                return PinnableNavigator.this.pinnedNav.isPresent() && PinnableNavigator.this.pinnedNav.isVisible() || PinnableNavigator.this.unpinnedNav.isPresent() && PinnableNavigator.this.unpinnedNav.isVisible();
            }
        };
        Poller.waitUntilTrue((String)"Pinned or Unpinned view never became visible", (TimedQuery)Conditions.forSupplier((long)10000L, (Supplier)supplier));
    }

    public Boolean isPinned() {
        return this.pinnedNav.isPresent() && this.pinnedNav.isVisible();
    }

    private Navigator navigator() {
        return this.isPinned() != false ? (Navigator)this.pageBinder.bind(PinnedView.class, new Object[0]) : (Navigator)this.pageBinder.bind(UnpinnedView.class, new Object[0]);
    }

    @Override
    public List<String> getItemLabels() {
        return this.navigator().getItemLabels();
    }

    @Override
    public List<String> getItemLabelsForGroup(int index) {
        return this.navigator().getItemLabelsForGroup(index);
    }

    @Override
    public String getSelectedItemLabel() {
        return this.navigator().getSelectedItemLabel();
    }

    @Override
    public Navigator selectItem(String label) {
        return this.navigator().selectItem(label);
    }

    @Override
    public ManageDialog manage() {
        return this.navigator().manage();
    }

    public Navigator pin() {
        if (this.isPinned().booleanValue()) {
            throw new RuntimeException("Cannot pin navigator when already in a pinned state");
        }
        return ((UnpinnedView)this.pageBinder.bind(UnpinnedView.class, new Object[0])).pin();
    }

    public Navigator unpin() {
        if (!this.isPinned().booleanValue()) {
            throw new RuntimeException("Cannot unpin navigator when already in a unpinned state");
        }
        return ((PinnedView)this.pageBinder.bind(PinnedView.class, new Object[0])).unpin();
    }
}

