/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.pinnablenavigator;

import com.atlassian.jira.pageobjects.util.TraceContext;
import com.atlassian.jira.pageobjects.util.Tracer;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementActions;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class ManageDialog {
    @ElementBy(className="manage-subnav-dialog")
    private PageElement manageDialog;
    @ElementBy(className="js-manage-save-button")
    private PageElement saveButton;
    @ElementBy(className="js-sortable-items")
    private PageElement sortableList;
    @Inject
    private TraceContext traceContext;
    @Inject
    private PageElementActions actions;

    public ManageDialog moveToEnd(String label) {
        PageElement source = this.getItemByLabel(label);
        source.javascript().execute("jQuery(arguments[0]).trigger('moveToEnd')", new Object[0]);
        return this;
    }

    private PageElement getItemByLabel(String label) {
        return this.manageDialog.find(By.cssSelector((String)(".js-manage-item[data-label='" + label + "']")));
    }

    public ManageDialog delete(String ... labels) {
        for (String label : labels) {
            this.getItemByLabel(label).find(By.className((String)"subnav-item-delete")).click();
        }
        return this;
    }

    public void save() {
        Tracer checkpoint = this.traceContext.checkpoint();
        this.saveButton.click();
        this.traceContext.waitFor(checkpoint, "jira.projects.items.updated");
    }
}

