/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.func.support;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ReportPanel {
    private final List<ReportCategory> reportCategories;

    public ReportPanel(Element element) {
        Elements reportCategoryElements = element.select(".reports__category");
        this.reportCategories = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)reportCategoryElements, (Function)new Function<Element, ReportCategory>(){

            public ReportCategory apply(Element categoryElement) {
                Elements reportElements = categoryElement.nextElementSibling().select(".reports__list__item");
                return new ReportCategory(categoryElement.text(), (List<Report>)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)reportElements, (Function)new Function<Element, Report>(){

                    public Report apply(Element reportElement) {
                        Element link = reportElement.select(".reports__list__report").first();
                        Element description = reportElement.select("p").first();
                        String thumbnailCssClass = link.className().replace("reports__list__report", "").trim();
                        return new Report(link.text(), description.text(), thumbnailCssClass, link.attr("href"));
                    }
                })));
            }
        }));
    }

    public List<ReportCategory> getReportCategories() {
        return this.reportCategories;
    }

    public static class Report {
        private final String name;
        private final String description;
        private final String thumbnailClass;
        private final String url;

        public Report(String name, String description, String thumbnailClass, String url) {
            this.name = name;
            this.thumbnailClass = thumbnailClass;
            this.url = url;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getThumbnailClass() {
            return this.thumbnailClass;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Report)) {
                return false;
            }
            Report report = (Report)o;
            if (!this.description.equals(report.description)) {
                return false;
            }
            if (!this.name.equals(report.name)) {
                return false;
            }
            if (!this.url.equals(report.url)) {
                return false;
            }
            return this.thumbnailClass.equals(report.thumbnailClass);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.thumbnailClass.hashCode();
            result = 31 * result + this.url.hashCode();
            result = 31 * result + this.description.hashCode();
            return result;
        }
    }

    public static class ReportCategory {
        private final String name;
        private final List<Report> reports;

        public ReportCategory(String name, List<Report> reports) {
            this.name = name;
            this.reports = reports;
        }

        public String getName() {
            return this.name;
        }

        public List<Report> getReports() {
            return this.reports;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReportCategory that = (ReportCategory)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.reports != null ? !this.reports.equals(that.reports) : that.reports != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.reports != null ? this.reports.hashCode() : 0);
            return result;
        }
    }
}

