/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.func.support;

import com.atlassian.jira.projects.pageobjects.func.support.TestUtilities;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.jsoup.nodes.Element;

public class NewSummaryPanel {
    private final List<ProjectVignetteElement> vignette;
    private final String description;

    public NewSummaryPanel(Element contents) {
        this.vignette = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)contents.select(".project-meta dt"), (Function)new Function<Element, ProjectVignetteElement>(){

            public ProjectVignetteElement apply(@Nullable Element input) {
                return new ProjectVignetteElement(input.text(), input.nextElementSibling().text());
            }
        }));
        this.description = TestUtilities.selectOnly(contents, ".project-description").text();
    }

    public List<ProjectVignetteElement> getVignette() {
        return this.vignette;
    }

    public String getDescription() {
        return this.description;
    }

    public static class ProjectVignetteElement {
        private final String title;
        private final String value;

        public ProjectVignetteElement(String title, String value) {
            this.title = title;
            this.value = value;
        }

        public String getTitle() {
            return this.title;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ProjectVignetteElement)) {
                return false;
            }
            ProjectVignetteElement that = (ProjectVignetteElement)o;
            if (!this.title.equals(that.title)) {
                return false;
            }
            return this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.title.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return this.title + "=" + this.value;
        }
    }
}

