/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.api.sidebar.navigation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class NavigationItem {
    private final List<NavigationItem> children;
    private final String href;
    private final Option<String> iconClass;
    private final Option<String> iconUrl;
    private final String id;
    private final Option<String> styleClass;
    private final String label;
    private final Option<String> badgeLabel;
    private final Option<String> badgeDescription;

    private NavigationItem(String href, String iconClass, String iconUrl, String id, String styleClass, String label, List<NavigationItem> children, String badgeLabel, String badgeDescription) {
        Preconditions.checkNotNull((Object)href, (Object)"An href must be provided for the Navigation Item");
        Preconditions.checkNotNull((Object)id, (Object)"The Navigation Item must have an ID");
        Preconditions.checkNotNull((Object)label, (Object)"The Navigation Item must have a label");
        this.href = href;
        this.id = id;
        this.styleClass = Option.option((Object)styleClass);
        this.iconClass = Option.option((Object)iconClass);
        this.iconUrl = Option.option((Object)iconUrl);
        this.label = label;
        this.children = children;
        this.badgeLabel = Option.option((Object)badgeLabel);
        this.badgeDescription = Option.option((Object)badgeDescription);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<NavigationItem> getChildren() {
        return Lists.newArrayList(this.children);
    }

    public String getHref() {
        return this.href;
    }

    public String getIconClass() {
        return (String)this.iconClass.getOrElse((Object)"");
    }

    public String getId() {
        return this.id;
    }

    public String getStyleClass() {
        return (String)this.styleClass.getOrElse((Object)"");
    }

    public String getLabel() {
        return this.label;
    }

    public String getBadgeLabel() {
        return (String)this.badgeLabel.getOrElse((Object)"");
    }

    public String getBadgeDescription() {
        return (String)this.badgeDescription.getOrElse((Object)"");
    }

    public String getIconUrl() {
        return (String)this.iconUrl.getOrElse((Object)"");
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        NavigationItem navigationItem = (NavigationItem)object;
        return new EqualsBuilder().append((Object)this.href, (Object)navigationItem.href).append(this.iconClass, navigationItem.iconClass).append(this.iconUrl, navigationItem.iconUrl).append((Object)this.id, (Object)navigationItem.id).append((Object)this.getStyleClass(), (Object)navigationItem.getStyleClass()).append((Object)this.label, (Object)navigationItem.label).append(this.children, navigationItem.children).append((Object)this.getBadgeLabel(), (Object)navigationItem.getBadgeLabel()).append((Object)this.getBadgeDescription(), (Object)navigationItem.getBadgeDescription()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.href).append(this.iconClass).append(this.iconUrl).append((Object)this.id).append(this.styleClass).append((Object)this.label).append(this.children).append(this.badgeLabel).append(this.badgeDescription).toHashCode();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class Builder {
        private final List<NavigationItem> children = Lists.newArrayList();
        private String href;
        private String iconClass;
        private String id;
        private String styleClass;
        private String label;
        private String iconUrl;
        private String badgeLabel;
        private String badgeDescription;

        private Builder() {
        }

        public Builder addChild(NavigationItem child) {
            this.children.add(child);
            return this;
        }

        public Builder addChildren(List<NavigationItem> children) {
            this.children.addAll(children);
            return this;
        }

        public NavigationItem build() {
            return new NavigationItem(this.href, this.iconClass, this.iconUrl, this.id, this.styleClass, this.label, this.children, this.badgeLabel, this.badgeDescription);
        }

        public Builder setHref(String href) {
            this.href = href;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setStyleClass(String styleClass) {
            this.styleClass = styleClass;
            return this;
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder setIconClass(String iconClass) {
            this.iconClass = iconClass;
            return this;
        }

        public Builder setIconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public Builder setBadgeLabel(String badgeLabel) {
            this.badgeLabel = badgeLabel;
            return this;
        }

        public Builder setBadgeDescription(String badgeDescription) {
            this.badgeDescription = badgeDescription;
            return this;
        }
    }
}

