/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.api.condition;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PathMatchesExpectedPathCondition
implements Condition {
    private Map<String, String> params;

    public void init(Map<String, String> params) throws PluginParseException {
        this.params = params;
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        String expectedPath = this.params.get("expectedPath");
        String path = (String)context.get("path");
        return PathMatchesExpectedPathCondition.equalAllowingForTrailingSlashes(path, expectedPath);
    }

    private static boolean equalAllowingForTrailingSlashes(String path, String expectedPath) {
        if (StringUtils.isBlank((CharSequence)path) || StringUtils.isBlank((CharSequence)expectedPath)) {
            return false;
        }
        String pathRemainder = StringUtils.substringAfter((String)path, (String)expectedPath);
        return StringUtils.startsWith((CharSequence)path, (CharSequence)expectedPath) && StringUtils.containsOnly((CharSequence)pathRemainder, (String)"/");
    }
}

