/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.api.condition;

import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class IsOfProjectTypeCondition
implements Condition {
    private static final String PROJECT_TYPE_PARAM_KEY = "projectType";
    private static final String PROJECT_CONTEXT_KEY = "project";
    private String projectTypeToMatch;
    private ApplicationAuthorizationService applicationAuthorizationService;

    public IsOfProjectTypeCondition(ApplicationAuthorizationService applicationAuthorizationService) {
        this.applicationAuthorizationService = applicationAuthorizationService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        if (!params.containsKey(PROJECT_TYPE_PARAM_KEY) || StringUtils.isBlank((CharSequence)params.get(PROJECT_TYPE_PARAM_KEY))) {
            throw new PluginParseException("IsOfProjectTypeCondition requires the 'projectType' parameter.");
        }
        this.projectTypeToMatch = StringUtils.trim((String)params.get(PROJECT_TYPE_PARAM_KEY));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        if (this.applicationAuthorizationService.rolesEnabled() && context.containsKey(PROJECT_CONTEXT_KEY)) {
            Project project = (Project)context.get(PROJECT_CONTEXT_KEY);
            Optional<ProjectTypeKey> type = Optional.ofNullable(project.getProjectTypeKey());
            return type.map(projectTypeKey -> projectTypeKey.getKey().equals(this.projectTypeToMatch)).orElse(false);
        }
        return false;
    }
}

