/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.inviteuser.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.plugin.inviteuser.Invitation;
import com.atlassian.jira.plugin.inviteuser.ao.AOInvitationStore;
import com.atlassian.jira.plugin.inviteuser.ao.InvitationEntity;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class AOInvitationStoreImpl
implements AOInvitationStore {
    private static final String ENCODE_DELIMETER = ",";
    private final ActiveObjects activeObjects;

    public AOInvitationStoreImpl(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    @Override
    public Invitation getInvitationByToken(String token) {
        InvitationEntity[] entities = (InvitationEntity[])this.activeObjects.find(InvitationEntity.class, "TOKEN = ?", new Object[]{token});
        if (entities.length == 0) {
            return null;
        }
        return AOInvitationStoreImpl.convert(entities[0]);
    }

    @Override
    public Collection<Invitation> getInvitationsByEmail(String emailAddress) {
        return AOInvitationStoreImpl.convert((InvitationEntity[])this.activeObjects.find(InvitationEntity.class, "EMAIL_ADDRESS = ?", new Object[]{emailAddress}));
    }

    @Override
    public Collection<Invitation> getAllInvitations() {
        return AOInvitationStoreImpl.convert((InvitationEntity[])this.activeObjects.find(InvitationEntity.class));
    }

    @Override
    public void addInvitation(Invitation invitation) {
        InvitationEntity entity = (InvitationEntity)this.activeObjects.create(InvitationEntity.class, new DBParam[0]);
        entity.setEmailAddress(invitation.getEmailAddress());
        entity.setToken(invitation.getToken());
        entity.setExpiry(invitation.getExpiry());
        entity.setSenderUsername(invitation.getSenderUsername());
        entity.setRedeemed(false);
        entity.setApplicationKeys(AOInvitationStoreImpl.encodeApplicationKeys(invitation.getApplicationKeys()));
        entity.save();
    }

    @Override
    public int redeemInvitationsByEmail(String emailAddress) {
        InvitationEntity[] entities;
        for (InvitationEntity entity : entities = (InvitationEntity[])this.activeObjects.find(InvitationEntity.class, "EMAIL_ADDRESS = ?", new Object[]{emailAddress})) {
            entity.setRedeemed(true);
            entity.save();
        }
        return entities.length;
    }

    @Override
    public void removeInvitationByToken(String token) {
        InvitationEntity[] entities = (InvitationEntity[])this.activeObjects.find(InvitationEntity.class, "TOKEN = ?", new Object[]{token});
        this.activeObjects.delete((RawEntity[])entities);
    }

    @Override
    public int removeInvitationsByEmail(String emailAddress) {
        InvitationEntity[] entities = (InvitationEntity[])this.activeObjects.find(InvitationEntity.class, "EMAIL_ADDRESS = ?", new Object[]{emailAddress});
        this.activeObjects.delete((RawEntity[])entities);
        return entities.length;
    }

    private static Invitation convert(InvitationEntity entity) {
        Set<ApplicationKey> applicationKeys = AOInvitationStoreImpl.decodeApplicationKeys(entity.getApplicationKeys());
        return new Invitation(entity.getEmailAddress(), entity.getToken(), entity.getExpiry(), entity.getSenderUsername(), entity.getRedeemed(), applicationKeys);
    }

    private static Collection<Invitation> convert(InvitationEntity[] entities) {
        ArrayList<Invitation> result = new ArrayList<Invitation>(entities.length);
        for (InvitationEntity entity : entities) {
            result.add(AOInvitationStoreImpl.convert(entity));
        }
        return result;
    }

    private static Set<ApplicationKey> decodeApplicationKeys(String encodedValue) {
        return (Set)Optional.ofNullable(encodedValue).filter(appKey -> !appKey.isEmpty()).map(appKeys -> (ImmutableSet)Arrays.stream(appKeys.split(ENCODE_DELIMETER)).filter(ApplicationKey::isValid).map(ApplicationKey::valueOf).collect(CollectorsUtil.toImmutableSet())).orElse(ImmutableSet.of());
    }

    private static String encodeApplicationKeys(Set<ApplicationKey> applicationKeys) {
        return Joiner.on((String)ENCODE_DELIMETER).join(applicationKeys);
    }
}

