/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.inviteuser;

import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.mail.MailService;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.plugin.inviteuser.Invitation;
import com.atlassian.jira.plugin.inviteuser.InvitationMailService;
import com.atlassian.jira.user.ApplicationUser;
import java.util.HashMap;

public class InvitationMailServiceImpl
implements InvitationMailService {
    private static final String TEMPLATE_DIR = "templates/email/";
    private static final String TEMPLATE_FILE = "invitation.vm";
    private final ApplicationProperties applicationProperties;
    private final MailService mailService;
    private final FeatureManager featureManager;

    public InvitationMailServiceImpl(ApplicationProperties applicationProperties, MailService mailService, FeatureManager featureManager) {
        this.applicationProperties = applicationProperties;
        this.mailService = mailService;
        this.featureManager = featureManager;
    }

    @Override
    public void sendInvitationEmail(ApplicationUser from, Invitation invitation) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("from", from);
        params.put("applicationName", this.getApplicationName());
        params.put("product", this.getProduct());
        params.put("signupUrl", this.getSignupUrl(invitation));
        NotificationRecipient toUser = new NotificationRecipient(invitation.getEmailAddress());
        String subjectTemplatePath = "templates/email/subject/invitation.vm";
        String bodyTemplatePath = "templates/email/invitation.vm";
        this.mailService.sendRenderedMail(from, toUser, "templates/email/subject/invitation.vm", "templates/email/invitation.vm", params);
    }

    private String getApplicationName() {
        return this.applicationProperties.getText("jira.title");
    }

    public String getProduct() {
        return this.featureManager.isEnabled(CoreFeatures.ON_DEMAND) ? "ondemand" : "jira";
    }

    public String getSignupUrl(Invitation invitation) {
        String baseUrl = this.applicationProperties.getText("jira.baseurl");
        return baseUrl + "/secure/InvitationSignUp!default.jspa?token=" + invitation.getToken();
    }
}

