/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.inviteuser;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.inviteuser.Invitation;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

public interface InvitationService {
    public Invitation getInvitationByToken(String var1);

    public Collection<Invitation> getInvitationsByEmail(String var1);

    public Collection<Invitation> getAllInvitations();

    public SendValidationResult validateSendInvitation(ApplicationUser var1, String var2, Expiry var3, Set<ApplicationKey> var4);

    public SendValidationResult validateSendInvitation(ApplicationUser var1, String var2, Date var3, Set<ApplicationKey> var4);

    public Invitation sendInvitation(SendValidationResult var1);

    public RedeemValidationResult validateRedeemInvitation(Invitation var1);

    public int redeemInvitation(RedeemValidationResult var1);

    public void removeInvitationByToken(String var1);

    public int removeInvitationsByEmail(String var1);

    public static class RedeemValidationResult
    extends ServiceResultImpl {
        Invitation invitation;

        public RedeemValidationResult(Invitation invitation, ErrorCollection errorCollection) {
            super(errorCollection);
            this.invitation = invitation;
        }

        public Invitation getInvitation() {
            return this.invitation;
        }
    }

    public static class SendValidationResult
    extends ServiceResultImpl {
        private final ApplicationUser from;
        private final String emailAddress;
        private final Date expiry;
        private final BadEmail reason;
        private final Set<ApplicationKey> applicationKeys;

        public SendValidationResult(ApplicationUser from, String emailAddress, Date expiry, BadEmail reason, Set<ApplicationKey> applicationKeys) {
            super(SendValidationResult.getErrors(from, reason));
            this.from = from;
            this.emailAddress = emailAddress;
            this.expiry = expiry;
            this.reason = reason;
            this.applicationKeys = applicationKeys;
        }

        private static ErrorCollection getErrors(ApplicationUser from, BadEmail reason) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            if (reason != null) {
                errors.addError("email", reason.getInlineError(from));
            }
            return errors;
        }

        public ApplicationUser getFrom() {
            return this.from;
        }

        public String getEmailAddress() {
            return this.emailAddress;
        }

        public Date getExpiry() {
            return this.expiry;
        }

        public String getReasonIcon() {
            return this.reason.getIcon();
        }

        public String getReasonMessage() {
            return this.reason.getListError(this.from);
        }

        public Set<ApplicationKey> getApplicationKeys() {
            return this.applicationKeys;
        }
    }

    public static enum BadEmail {
        BLANK("required"),
        ALREADY_INVITED("already.invited"),
        EXISTING_USER("already.registered"),
        INVALID_EMAIL("invalid");

        private final String i18nKey;

        private BadEmail(String i18nKey) {
            this.i18nKey = i18nKey;
        }

        private static I18nHelper getI18n(ApplicationUser user) {
            I18nHelper.BeanFactory beanFactory = (I18nHelper.BeanFactory)ComponentAccessor.getComponent(I18nHelper.BeanFactory.class);
            return beanFactory.getInstance(user);
        }

        public String getInlineError(ApplicationUser user) {
            return BadEmail.getI18n(user).getText("inviteuser.error.email." + this.i18nKey);
        }

        public String getListError(ApplicationUser user) {
            return BadEmail.getI18n(user).getText("inviteuser.short.error.email." + this.i18nKey);
        }

        public String getIcon() {
            if (ALREADY_INVITED.equals((Object)this)) {
                return "icon-tick";
            }
            if (EXISTING_USER.equals((Object)this)) {
                return "icon-user";
            }
            return "icon-cross";
        }
    }

    public static enum Expiry {
        ONE_WEEK,
        DOES_NOT_EXPIRE;


        public Date getExpiryDate() {
            return this.getExpiryDate(null);
        }

        public Date getExpiryDate(Date fromDate) {
            if (this == DOES_NOT_EXPIRE) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            if (fromDate != null) {
                cal.setTime(fromDate);
            }
            switch (this) {
                case ONE_WEEK: {
                    cal.add(6, 7);
                }
            }
            return cal.getTime();
        }
    }
}

