/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.inviteuser;

import com.atlassian.application.api.ApplicationKey;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;

public class Invitation {
    private final String emailAddress;
    private final String token;
    private final Date expiry;
    private final String senderUsername;
    private final boolean redeemed;
    private final Set<ApplicationKey> applicationKeys;

    public Invitation(String emailAddress, String token, Date expiry, String senderUsername, @Nonnull Set<ApplicationKey> applicationKeys) {
        this(emailAddress, token, expiry, senderUsername, false, applicationKeys);
    }

    public Invitation(String emailAddress, String token, Date expiry, String senderUsername, boolean redeemed, @Nonnull Set<ApplicationKey> applicationKeys) {
        Preconditions.checkNotNull(applicationKeys);
        this.emailAddress = emailAddress;
        this.token = token;
        this.expiry = expiry;
        this.senderUsername = senderUsername;
        this.redeemed = redeemed;
        this.applicationKeys = applicationKeys;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getToken() {
        return this.token;
    }

    public Date getExpiry() {
        return this.expiry;
    }

    public boolean isRedeemed() {
        return this.redeemed;
    }

    public String getSenderUsername() {
        return this.senderUsername;
    }

    @Nonnull
    public Set<ApplicationKey> getApplicationKeys() {
        return this.applicationKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invitation that = (Invitation)o;
        return Objects.equal((Object)this.emailAddress, (Object)that.emailAddress) && Objects.equal((Object)this.token, (Object)that.token) && Objects.equal(this.applicationKeys, that.applicationKeys);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.emailAddress, this.token, this.applicationKeys});
    }
}

