/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MainHeaderLinksContextProvider
implements ContextProvider {
    static final String SYSTEM_TOP_NAVIGATION_BAR = "system.top.navigation.bar";
    static final String LAZY_HEADER_LINKS_KEY = "lazyMainHeaderLinks";
    static final String DROPDOWN_SECTIONS_KEY = "dropdownSectionsMap";
    static final String DROPDOWN_LINKS_KEY = "dropdownLinksMap";
    static final String TOPLEVEL_ITEMS_KEY = "toplevelItems";
    static final String MORE_ITEMS_KEY = "moreItems";
    private final SimpleLinkManager simpleLinkManager;
    private final JiraAuthenticationContext authenticationContext;
    private Set<String> toplevelItems;

    public MainHeaderLinksContextProvider(@Nonnull SimpleLinkManager simpleLinkManager, @Nonnull JiraAuthenticationContext authenticationContext) {
        this.simpleLinkManager = (SimpleLinkManager)Assertions.notNull((Object)simpleLinkManager);
        this.authenticationContext = (JiraAuthenticationContext)Assertions.notNull((Object)authenticationContext);
    }

    public void init(Map<String, String> params) throws PluginParseException {
        this.toplevelItems = this.filterToplevelItems(params);
    }

    private Set<String> filterToplevelItems(Map<String, String> params) {
        return Sets.newHashSet(Maps.filterKeys(params, (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String s) {
                return s.startsWith("toplevel-item");
            }
        }).values());
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        User user = this.authenticationContext.getLoggedInUser();
        JiraHelper helper = (JiraHelper)context.get("helper");
        List mainHeaderLinks = this.simpleLinkManager.getLinksForSection(SYSTEM_TOP_NAVIGATION_BAR, user, helper);
        Iterable displayedToplevelItems = Iterables.filter((Iterable)mainHeaderLinks, this.isToplevelItem());
        Iterable displayedMoreItems = Iterables.filter((Iterable)mainHeaderLinks, (Predicate)Predicates.not(this.isToplevelItem()));
        Set<String> lazyMainHeaderLinks = this.collectLazyMainHeaderLinks(mainHeaderLinks, user, helper);
        Set<String> nonLazyMainHeaderLinks = this.collectNonLazyMainHeaderLinks(mainHeaderLinks, lazyMainHeaderLinks, user, helper);
        Map<String, List<SimpleLinkSection>> nonLazyMainHeaderLinkIdsToSectionList = this.collectSectionsForNonLazyMainHeaderLinks(nonLazyMainHeaderLinks, user, helper);
        Map<String, List<SimpleLink>> sectionIdToLinksList = this.collectLinksForSections(nonLazyMainHeaderLinkIdsToSectionList, user, helper);
        return MapBuilder.newBuilder(context).add((Object)LAZY_HEADER_LINKS_KEY, lazyMainHeaderLinks).add((Object)DROPDOWN_SECTIONS_KEY, nonLazyMainHeaderLinkIdsToSectionList).add((Object)DROPDOWN_LINKS_KEY, sectionIdToLinksList).add((Object)TOPLEVEL_ITEMS_KEY, (Object)Lists.newArrayList((Iterable)displayedToplevelItems)).add((Object)MORE_ITEMS_KEY, (Object)Lists.newArrayList((Iterable)displayedMoreItems)).toHashMap();
    }

    private Predicate<SimpleLink> isToplevelItem() {
        return new Predicate<SimpleLink>(){

            public boolean apply(@Nullable SimpleLink simpleLink) {
                return true;
            }
        };
    }

    @Nonnull
    private Set<String> collectLazyMainHeaderLinks(@Nonnull List<SimpleLink> mainHeaderLinks, @Nullable User user, @Nonnull JiraHelper helper) {
        HashSet<String> result = new HashSet<String>();
        for (SimpleLink mainHeaderLink : mainHeaderLinks) {
            String mainHeaderLinkId = mainHeaderLink.getId();
            if (!this.simpleLinkManager.shouldLocationBeLazy(mainHeaderLinkId, user, helper)) continue;
            result.add(mainHeaderLinkId);
        }
        return result;
    }

    @Nonnull
    private Set<String> collectNonLazyMainHeaderLinks(@Nonnull List<SimpleLink> mainHeaderLinks, @Nonnull Set<String> lazyMainHeaderLinks, @Nullable User user, @Nonnull JiraHelper helper) {
        if (mainHeaderLinks.size() == lazyMainHeaderLinks.size()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (SimpleLink mainHeaderLink : mainHeaderLinks) {
            String mainHeaderLinkId = mainHeaderLink.getId();
            if (lazyMainHeaderLinks.contains(mainHeaderLinkId)) continue;
            result.add(mainHeaderLinkId);
        }
        return result;
    }

    @Nonnull
    private Map<String, List<SimpleLinkSection>> collectSectionsForNonLazyMainHeaderLinks(@Nonnull Set<String> nonLazyMainHeaderLinkIds, @Nullable User user, @Nonnull JiraHelper helper) {
        HashMap<String, List<SimpleLinkSection>> result = new HashMap<String, List<SimpleLinkSection>>();
        for (String mainHeaderLinkId : nonLazyMainHeaderLinkIds) {
            List sections = this.simpleLinkManager.getSectionsForLocation(mainHeaderLinkId, user, helper);
            result.put(mainHeaderLinkId, sections);
        }
        return result;
    }

    @Nonnull
    private Map<String, List<SimpleLink>> collectLinksForSections(@Nonnull Map<String, List<SimpleLinkSection>> mainHeaderLinkIdsToSectionList, @Nullable User user, @Nonnull JiraHelper helper) {
        HashMap<String, List<SimpleLink>> result = new HashMap<String, List<SimpleLink>>();
        for (Map.Entry<String, List<SimpleLinkSection>> mainHeaderLinkIdToSectionList : mainHeaderLinkIdsToSectionList.entrySet()) {
            String mainHeaderLinkId = mainHeaderLinkIdToSectionList.getKey();
            List<SimpleLinkSection> sectionList = mainHeaderLinkIdToSectionList.getValue();
            for (SimpleLinkSection section : sectionList) {
                String sectionKey = mainHeaderLinkId + "/" + section.getId();
                List linksForSection = this.simpleLinkManager.getLinksForSection(sectionKey, user, helper);
                result.put(sectionKey, linksForSection);
            }
        }
        return result;
    }
}

