/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HelpMenuContextProvider
implements ContextProvider {
    static final String SYSTEM_USER_OPTIONS = "system.user.options";
    static final String HELP_SECTION_ID = "jira-help";
    static final String SECTIONS_KEY = "displayableSections";
    static final String SECTION_LINKS_KEY = "completeSectionKeyToDisplayableItems";
    static final String HELP_LINK_KEY = "rootHelpMenuItem";
    private final SimpleLinkManager simpleLinkManager;
    private final JiraAuthenticationContext authenticationContext;

    public HelpMenuContextProvider(@Nonnull SimpleLinkManager simpleLinkManager, @Nonnull JiraAuthenticationContext authenticationContext) {
        this.simpleLinkManager = (SimpleLinkManager)Assertions.notNull((Object)simpleLinkManager);
        this.authenticationContext = (JiraAuthenticationContext)Assertions.notNull((Object)authenticationContext);
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        User user = this.authenticationContext.getLoggedInUser();
        JiraHelper helper = (JiraHelper)context.get("helper");
        List<SimpleLinkSection> displayableSections = this.collectDisplayableSections(user, helper);
        Map<String, List<SimpleLink>> sectionToDisplayableItems = this.collectDisplayableItemsForSections(displayableSections, user, helper);
        SimpleLink rootHelpMenuItem = this.getRootHelpMenuItem(displayableSections, sectionToDisplayableItems);
        return MapBuilder.newBuilder(context).add((Object)"user", (Object)user).add((Object)SECTIONS_KEY, displayableSections).add((Object)SECTION_LINKS_KEY, sectionToDisplayableItems).add((Object)HELP_LINK_KEY, (Object)rootHelpMenuItem).toHashMap();
    }

    @Nonnull
    private List<SimpleLinkSection> collectDisplayableSections(@Nullable User user, @Nonnull JiraHelper helper) {
        List notEmptySectionsForLocation = this.simpleLinkManager.getNotEmptySectionsForLocation(SYSTEM_USER_OPTIONS, user, helper);
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)notEmptySectionsForLocation, (Predicate)new Predicate<SimpleLinkSection>(){

            public boolean apply(@Nullable SimpleLinkSection section) {
                return section != null && HelpMenuContextProvider.HELP_SECTION_ID.equals(section.getId());
            }
        }));
    }

    @Nonnull
    private Map<String, List<SimpleLink>> collectDisplayableItemsForSections(@Nonnull List<SimpleLinkSection> displayableSections, @Nullable User user, @Nonnull JiraHelper helper) {
        HashMap<String, List<SimpleLink>> result = new HashMap<String, List<SimpleLink>>();
        for (SimpleLinkSection displayableSection : displayableSections) {
            String sectionKey = "system.user.options/" + displayableSection.getId();
            List displayableItems = this.simpleLinkManager.getLinksForSection(sectionKey, user, helper);
            result.put(displayableSection.getId(), displayableItems);
        }
        return result;
    }

    @Nullable
    private SimpleLink getRootHelpMenuItem(@Nonnull List<SimpleLinkSection> displayableSections, @Nonnull Map<String, List<SimpleLink>> sectionToDisplayableItems) {
        for (SimpleLinkSection displayableSection : displayableSections) {
            List<SimpleLink> firstWebSectionItems = sectionToDisplayableItems.get(displayableSection.getId());
            if (firstWebSectionItems == null || firstWebSectionItems.isEmpty()) continue;
            return firstWebSectionItems.get(0);
        }
        return null;
    }
}

