/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav.navlinks.spi;

import com.atlassian.jira.plugin.headernav.customcontentlinks.admin.ProjectAdminPermissionChecker;
import com.atlassian.plugins.navlink.spi.Project;
import com.atlassian.plugins.navlink.spi.ProjectPermissionManager;

public class NavlinksProjectPermissionManager
implements ProjectPermissionManager {
    private final ProjectAdminPermissionChecker projectAdminPermissionChecker;
    private ThreadLocal<Boolean> isSysAdmin = new ThreadLocal();

    public NavlinksProjectPermissionManager(ProjectAdminPermissionChecker projectAdminPermissionChecker) {
        this.projectAdminPermissionChecker = projectAdminPermissionChecker;
    }

    public boolean canAdminister(Project project, String userName) {
        if (this.isSysAdmin.get() != null) {
            return true;
        }
        return this.projectAdminPermissionChecker.canAdminister(project.getKey(), userName);
    }

    public void setSysAdmin(boolean value) {
        if (value) {
            this.isSysAdmin.set(true);
        } else {
            this.isSysAdmin.remove();
        }
    }
}

