/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.plugin.navigation.PluggableTopNavigation;
import com.atlassian.jira.plugin.navigation.TopNavigationModuleDescriptor;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ModernPluggableTopNavigation
implements PluggableTopNavigation {
    private TopNavigationModuleDescriptor descriptor;
    private final WebInterfaceManager webInterfaceManager;
    private final SoyTemplateRenderer soy;
    private final ApplicationProperties applicationProperties;
    private FeatureManager featureManager;
    private final LookAndFeelBean lookAndFeelBean;

    public ModernPluggableTopNavigation(WebInterfaceManager webInterfaceManager, ApplicationProperties applicationProperties, FeatureManager featureManager, SoyTemplateRendererProvider soy) {
        this.webInterfaceManager = webInterfaceManager;
        this.applicationProperties = applicationProperties;
        this.featureManager = featureManager;
        this.lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
        this.soy = soy.getRenderer();
    }

    public void init(TopNavigationModuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getHtml(HttpServletRequest request) {
        Map<String, Object> context = this.getTopNavigationContext(request);
        StringBuilder leftSide = new StringBuilder();
        for (WebPanelModuleDescriptor moduleDescriptor : this.webInterfaceManager.getDisplayableWebPanelDescriptors("com.atlassian.jira.plugin.headernav.left.context", context)) {
            leftSide.append(((WebPanel)moduleDescriptor.getModule()).getHtml(context));
        }
        StringBuilder rightSide = new StringBuilder();
        for (WebPanelModuleDescriptor moduleDescriptor : this.webInterfaceManager.getDisplayableWebPanelDescriptors("com.atlassian.jira.plugin.headernav.right.context", context)) {
            rightSide.append(((WebPanel)moduleDescriptor.getModule()).getHtml(context));
        }
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("primaryNavContent", "<ul class='aui-nav'>" + leftSide.toString() + "</ul>");
            params.put("secondaryNavContent", "<ul class='aui-nav'>" + rightSide.toString() + "</ul>");
            this.insertAppSwitcher(params);
            params.put("headerLink", this.applicationProperties.getString("jira.baseurl") + "/secure/MyJiraHome.jspa");
            params.put("headerText", this.getHeaderText(this.shouldShowTitleInHeader()));
            params.put("logo", "");
            params.put("headerLogoText", this.getHeaderText(!this.shouldShowTitleInHeader()));
            params.put("headerLogoImageUrl", this.lookAndFeelBean.getAbsoluteLogoUrl());
            params.put("logo", "jira");
            params.put("logo", "");
            params.put("headerLogoText", this.getHeaderText(!this.shouldShowTitleInHeader()));
            params.put("headerLogoImageUrl", this.lookAndFeelBean.getAbsoluteLogoUrl());
            return this.soy.render("com.atlassian.auiplugin:aui-experimental-soy-templates", "aui.page.header", params);
        }
        catch (SoyException e) {
            throw new RuntimeException(e);
        }
    }

    private void insertAppSwitcher(Map<String, Object> params) throws SoyException {
        if (this.featureManager.isEnabled("app-switcher.new")) {
            params.put("headerBeforeContent", this.soy.render("com.atlassian.plugins.atlassian-nav-links-plugin:rotp-menu", "navlinks.templates.appswitcher.switcher", Collections.emptyMap()));
        } else {
            params.put("extraClasses", "app-switcher-old");
        }
    }

    private Map<String, Object> getTopNavigationContext(HttpServletRequest request) {
        Map params = this.descriptor.getTopNavigationContext(request, null);
        params.put("user", params.get("currentUser"));
        params.put("helper", params.get("jiraHelperWithProject"));
        return params;
    }

    private String getHeaderText(boolean shouldShow) {
        return shouldShow ? this.applicationProperties.getText("jira.title") : "";
    }

    private boolean shouldShowTitleInHeader() {
        return this.applicationProperties.getOption("jira.lf.logo.show.application.title");
    }
}

