/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;

public class AppSwitcherContextProvider
implements ContextProvider {
    private final MapBuilder<String, Object> contextMapBuilder = MapBuilder.newBuilder();
    private final ApplicationProperties applicationProperties;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public AppSwitcherContextProvider(ApplicationProperties applicationProperties, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.applicationProperties = applicationProperties;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        this.contextMapBuilder.addAll(params);
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        this.contextMapBuilder.add((Object)"baseurl", (Object)this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl());
        this.contextMapBuilder.add((Object)"logoUrl", (Object)this.getLookAndFeelSettings().getAbsoluteLogoUrl());
        this.contextMapBuilder.add((Object)"logoWidth", (Object)this.getLookAndFeelSettings().getLogoWidth());
        this.contextMapBuilder.add((Object)"applicationTitle", (Object)this.applicationProperties.getDefaultBackedString("jira.title"));
        this.contextMapBuilder.add((Object)"logoHeight", (Object)"30 px");
        return CompositeMap.of(context, (Map)this.contextMapBuilder.toMutableMap());
    }

    @VisibleForTesting
    LookAndFeelBean getLookAndFeelSettings() {
        return LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
    }
}

