/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.webtests.table.TextCell;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryItem;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryRecord;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestWorkflowWithOriginalStepTransitions
extends FuncTestCase {
    @Override
    public void setUpTest() {
        this.administration.restoreData("TestWorkflowWithOriginalStepTransitions.xml");
    }

    public void testWorkflowEditor() throws SAXException {
        this.navigation.gotoWorkflows();
        this.tester.assertTextPresent("workflow with originating_step transition");
        this.tester.clickLink("steps_live_workflow with originating_step transition");
        WebTable stepsTable = new TableLocator(this.tester, "steps_table").getTable();
        this.assertions.getTableAssertions().assertTableRowEquals(stepsTable, 1, new Object[]{new TextCell("Open", "(1)"), new TextCell("Open"), new TextCell(new String[]{"Start Progress", "(4)", ">>", "In Progress", "Resolve Issue", "(5)", ">>", "Resolved", "Close Issue", "(2)", ">>", "Open"}), null});
        this.text.assertTextNotPresent(new TableCellLocator(this.tester, "steps_table", 1, 2), "Closed");
        this.assertions.getTableAssertions().assertTableRowEquals(stepsTable, 2, new Object[]{new TextCell("In Progress", "(3)"), new TextCell("In Progress"), new TextCell(new String[]{"Stop Progress", "(301)", ">>", "Open", "Resolve Issue", "(5)", ">>", "Resolved", "Close Issue", "(2)", ">>", "In Progress"}), null});
        this.text.assertTextNotPresent(new TableCellLocator(this.tester, "steps_table", 2, 2), "Closed");
        this.assertions.getTableAssertions().assertTableRowEquals(stepsTable, 3, new Object[]{new TextCell("Resolved", "(4)"), new TextCell("Resolved"), new TextCell(new String[]{"Close Issue", "(701)", ">>", "Closed", "Reopen Issue", "(3)", ">>", "Reopened"}), null});
        this.text.assertTextNotPresent(new TableCellLocator(this.tester, "steps_table", 3, 2), "Resolved");
        this.assertions.getTableAssertions().assertTableRowEquals(stepsTable, 4, new Object[]{new TextCell("Reopened", "(5)"), new TextCell("Reopened"), new TextCell(new String[]{"Resolve Issue", "(5)", ">>", "Resolved", "Close Issue", "(2)", ">>", "Reopened", "Start Progress", "(4)", ">>", "In Progress"}), null});
        this.text.assertTextNotPresent(new TableCellLocator(this.tester, "steps_table", 4, 2), "Closed");
        this.assertions.getTableAssertions().assertTableRowEquals(stepsTable, 5, new Object[]{new TextCell("Closed", "(6)"), new TextCell("Closed"), new TextCell(new String[]{"Reopen Issue", "(3)", ">>", "Reopened"}), null});
        this.text.assertTextNotPresent(new TableCellLocator(this.tester, "steps_table", 5, 2), "Closed");
        this.tester.clickLinkWithText("Close Issue");
        WorkflowBrowser workflowBrowser = new WorkflowBrowser();
        MatcherAssert.assertThat(workflowBrowser.getOrigins(), (Matcher)Matchers.contains((Object[])new String[]{"Open", "In Progress", "Reopened"}));
        MatcherAssert.assertThat((Object)workflowBrowser.getCurrent(), (Matcher)Matchers.is((Object)"Close Issue"));
        MatcherAssert.assertThat(workflowBrowser.getDestinations(), (Matcher)Matchers.contains((Object[])new String[]{"Open", "In Progress", "Reopened"}));
        this.tester.clickLink("create_draft_workflow");
        this.tester.clickLinkWithText("Close Issue");
        MatcherAssert.assertThat(workflowBrowser.getOrigins(), (Matcher)Matchers.contains((Object[])new String[]{"Open", "In Progress", "Reopened"}));
        MatcherAssert.assertThat((Object)workflowBrowser.getCurrent(), (Matcher)Matchers.is((Object)"Close Issue"));
        MatcherAssert.assertThat(workflowBrowser.getDestinations(), (Matcher)Matchers.contains((Object[])new String[]{"Open", "In Progress", "Reopened"}));
        this.tester.clickLink("edit_transition");
        this.tester.assertOptionValuesEqual("destinationStep", new String[]{"1", "3", "4", "5", "6", "-1"});
        this.tester.setFormElement("description", "Adding a description");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Transition: Close Issue");
        this.tester.assertTextPresent("Adding a description");
        MatcherAssert.assertThat(workflowBrowser.getOrigins(), (Matcher)Matchers.contains((Object[])new String[]{"Open", "In Progress", "Reopened"}));
        MatcherAssert.assertThat((Object)workflowBrowser.getCurrent(), (Matcher)Matchers.is((Object)"Close Issue"));
        MatcherAssert.assertThat(workflowBrowser.getDestinations(), (Matcher)Matchers.contains((Object[])new String[]{"Open", "In Progress", "Reopened"}));
        this.tester.clickLink("edit_transition");
        this.tester.selectOption("destinationStep", "Closed");
        this.tester.submit("Update");
        MatcherAssert.assertThat(workflowBrowser.getOrigins(), (Matcher)Matchers.contains((Object[])new String[]{"Open", "In Progress", "Reopened"}));
        MatcherAssert.assertThat((Object)workflowBrowser.getCurrent(), (Matcher)Matchers.is((Object)"Close Issue"));
        MatcherAssert.assertThat(workflowBrowser.getDestinations(), (Matcher)Matchers.contains((Object[])new String[]{"Closed"}));
        this.tester.clickLink("edit_transition");
        this.tester.assertOptionValuesEqual("destinationStep", new String[]{"1", "3", "4", "5", "6"});
        this.tester.assertOptionValuesNotEqual("destinationStep", new String[]{"1", "3", "4", "5", "6", "-1"});
        this.tester.assertTextNotPresent("The originating step");
    }

    public void testTransitionSingleIssue() throws Exception {
        boolean isOracle = new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isOracle();
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertTextPresent("Details");
        this.tester.assertTextPresent("Test1");
        this.text.assertTextPresent(new IdLocator(this.tester, "status-val"), "Open");
        this.tester.clickLink("action_id_2");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.assertTextPresent("Close Issue");
        this.tester.submit("Transition");
        this.text.assertTextPresent(new IdLocator(this.tester, "status-val"), "Open");
        this.assertions.assertLastChangeHistoryRecords("HSP-1", new ExpectedChangeHistoryRecord(EasyList.build((Object)new ExpectedChangeHistoryItem("Resolution", null, "Fixed"), (Object)new ExpectedChangeHistoryItem("Status", "Open", "Open"))));
        if (isOracle) {
            Thread.sleep(2000L);
        }
        this.tester.clickLink("action_id_4");
        this.text.assertTextPresent(new IdLocator(this.tester, "status-val"), "In Progress");
        this.assertions.assertLastChangeHistoryRecords("HSP-1", new ExpectedChangeHistoryRecord(EasyList.build((Object)new ExpectedChangeHistoryItem("Resolution", "Fixed", null), (Object)new ExpectedChangeHistoryItem("Status", "Open", "In Progress"))));
        if (isOracle) {
            Thread.sleep(2000L);
        }
        this.tester.clickLink("action_id_2");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.assertTextPresent("Close Issue");
        this.tester.submit("Transition");
        this.text.assertTextPresent(new IdLocator(this.tester, "status-val"), "In Progress");
        this.assertions.assertLastChangeHistoryRecords("HSP-1", new ExpectedChangeHistoryRecord(EasyList.build((Object)new ExpectedChangeHistoryItem("Resolution", null, "Fixed"), (Object)new ExpectedChangeHistoryItem("Status", "In Progress", "In Progress"))));
    }

    public void testBulkTransition() {
        this.navigation.issue().viewIssue("HSP-3");
        this.text.assertTextPresent(new IdLocator(this.tester, "status-val"), "In Progress");
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextPresent(new IdLocator(this.tester, "status-val"), "Open");
        this.navigation.issue().viewIssue("HSP-2");
        this.text.assertTextPresent(new IdLocator(this.tester, "status-val"), "Open");
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10002", "on");
        this.tester.checkCheckbox("bulkedit_10001", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Workflow: workflow with originating_step transition");
        WebTable workflowTable = new TableLocator(this.tester, "workflow_0").getTable();
        this.assertions.getTableAssertions().assertTableRowEquals(workflowTable, 0, new Object[]{new TextCell("Available Workflow Actions"), new TextCell("Status Transition"), null, null, new TextCell("Affected Issues")});
        Object[] closeInProgressHsp3 = new Object[]{new TextCell("Close Issue"), new TextCell("In Progress"), null, new TextCell("In Progress"), new TextCell("HSP-3")};
        this.assertions.getTableAssertions().assertTableContainsRowOnce(workflowTable, closeInProgressHsp3);
        Object[] closeOpenHsp2 = new Object[]{new TextCell("Close Issue"), new TextCell("Open"), null, new TextCell("Open"), new TextCell("HSP-2")};
        this.assertions.getTableAssertions().assertTableContainsRowOnce(workflowTable, closeOpenHsp2);
        this.assertions.getTableAssertions().assertTableRowEquals(workflowTable, 3, new Object[]{new TextCell("Stop Progress"), null, null, new TextCell("Open"), new TextCell("HSP-3")});
        this.assertions.getTableAssertions().assertTableRowEquals(workflowTable, 4, new Object[]{new TextCell("Start Progress"), null, null, new TextCell("In Progress"), new TextCell("HSP-2")});
        this.assertions.getTableAssertions().assertTableRowEquals(workflowTable, 5, new Object[]{new TextCell("Resolve Issue"), null, null, new TextCell("Resolved"), new TextCell("HSP-2", "HSP-3")});
        this.tester.checkCheckbox("wftransition", "workflow with originating_step transition_2_3");
        this.tester.submit("Next");
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(locator, new String[]{"Workflow", "workflow with originating_step transition"});
        this.text.assertTextSequence(locator, new String[]{"Selected Transition", "Close Issue"});
        this.text.assertTextSequence(locator, new String[]{"Status Transition", "In Progress", "In Progress"});
        this.text.assertTextSequence(locator, new String[]{"This change will affect", "1", "issues."});
        this.tester.selectOption("resolution", "Fixed");
        this.tester.submit("Next");
        locator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(locator, new String[]{"Workflow", "workflow with originating_step transition"});
        this.text.assertTextSequence(locator, new String[]{"Selected Transition", "Close Issue"});
        this.text.assertTextSequence(locator, new String[]{"Status Transition", "In Progress", "In Progress"});
        this.text.assertTextSequence(locator, new String[]{"This change will affect", "1", "issues."});
        this.text.assertTextSequence(new TableLocator(this.tester, "updatedfields"), new String[]{"Resolution", "Fixed"});
        this.text.assertTextPresent("HSP-3");
        this.text.assertTextNotPresent("HSP-1");
        this.text.assertTextNotPresent("HSP-2");
        this.tester.submit("Next");
        this.navigation.issue().viewIssue("HSP-3");
        this.text.assertTextPresent(new IdLocator(this.tester, "status-val"), "In Progress");
        this.assertions.assertLastChangeHistoryRecords("HSP-3", new ExpectedChangeHistoryRecord(EasyList.build((Object)new ExpectedChangeHistoryItem("Resolution", null, "Fixed"), (Object)new ExpectedChangeHistoryItem("Status", "In Progress", "In Progress"))));
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.checkCheckbox("bulkedit_10001", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Workflow: workflow with originating_step transition");
        workflowTable = new TableLocator(this.tester, "workflow_0").getTable();
        this.assertions.getTableAssertions().assertTableRowEquals(workflowTable, 0, new Object[]{new TextCell("Available Workflow Actions"), new TextCell("Status Transition"), null, null, new TextCell("Affected Issues")});
        this.assertions.getTableAssertions().assertTableRowEquals(workflowTable, 1, new Object[]{new TextCell("Close Issue"), new TextCell("Open"), null, new TextCell("Open"), new TextCell("HSP-1", "HSP-2")});
        this.assertions.getTableAssertions().assertTableRowEquals(workflowTable, 2, new Object[]{new TextCell("Start Progress"), null, null, new TextCell("In Progress"), new TextCell("HSP-1", "HSP-2")});
        this.assertions.getTableAssertions().assertTableRowEquals(workflowTable, 3, new Object[]{new TextCell("Resolve Issue"), null, null, new TextCell("Resolved"), new TextCell("HSP-1", "HSP-2")});
        this.tester.checkCheckbox("wftransition", "workflow with originating_step transition_2_1");
        this.tester.submit("Next");
        locator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(locator, new String[]{"Workflow", "workflow with originating_step transition"});
        this.text.assertTextSequence(locator, new String[]{"Selected Transition", "Close Issue"});
        this.text.assertTextSequence(locator, new String[]{"Status Transition", "Open", "Open"});
        this.text.assertTextSequence(locator, new String[]{"This change will affect", "2", "issues."});
        this.tester.selectOption("resolution", "Fixed");
        this.tester.submit("Next");
        locator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(locator, new String[]{"Workflow", "workflow with originating_step transition"});
        this.text.assertTextSequence(locator, new String[]{"Selected Transition", "Close Issue"});
        this.text.assertTextSequence(locator, new String[]{"Status Transition", "Open", "Open"});
        this.text.assertTextSequence(locator, new String[]{"This change will affect", "2", "issues."});
        this.text.assertTextSequence(new TableLocator(this.tester, "updatedfields"), new String[]{"Resolution", "Fixed"});
        this.text.assertTextNotPresent("HSP-3");
        this.text.assertTextPresent("HSP-1");
        this.text.assertTextPresent("HSP-2");
        this.tester.submit("Next");
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextPresent(new IdLocator(this.tester, "status-val"), "Open");
        this.assertions.assertLastChangeHistoryRecords("HSP-1", new ExpectedChangeHistoryRecord(EasyList.build((Object)new ExpectedChangeHistoryItem("Resolution", null, "Fixed"), (Object)new ExpectedChangeHistoryItem("Status", "Open", "Open"))));
        this.navigation.issue().viewIssue("HSP-2");
        this.text.assertTextPresent(new IdLocator(this.tester, "status-val"), "Open");
        this.assertions.assertLastChangeHistoryRecords("HSP-2", new ExpectedChangeHistoryRecord(EasyList.build((Object)new ExpectedChangeHistoryItem("Resolution", null, "Fixed"), (Object)new ExpectedChangeHistoryItem("Status", "Open", "Open"))));
    }

    private class WorkflowBrowser {
        private WorkflowBrowser() {
        }

        public List<String> getOrigins() {
            return this.getItemsAsList("#orig_steps li");
        }

        public boolean isInitial() {
            return this.css("#orig_steps .workflow-transition-initial").exists();
        }

        private CssLocator css(String cssSelector) {
            return new CssLocator(TestWorkflowWithOriginalStepTransitions.this.getTester(), cssSelector);
        }

        public String getCurrent() {
            return (String)Iterables.getOnlyElement(this.getItemsAsList(".workflow-current-context li"));
        }

        public List<String> getDestinations() {
            return this.getItemsAsList("#dest_steps li");
        }

        private List<String> getItemsAsList(String cssSelector) {
            CssLocator cssLocator = this.css(cssSelector);
            ArrayList result = Lists.newArrayList();
            for (Node node : cssLocator.getNodes()) {
                String s = StringUtils.stripToNull((String)cssLocator.getText(node));
                if (s == null) continue;
                result.add(s);
            }
            return result;
        }
    }
}

