/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestWorkflowTransitionView
extends JIRAWebTest {
    private static final String TRANSITION_NAME_1 = "My Transition 1";
    private static final String TRANSITION_NAME_2 = "My Transition 2";
    private static final String TRANSITION_DESC = "This is a test transition";
    private static final String TRANSITION_FIELD_SCREEN = "No view for transition";

    public TestWorkflowTransitionView(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.administration.restoreBlankInstance();
    }

    private void copyWorkflowAndAddTransitions() {
        this.administration.workflows().goTo().copyWorkflow("jira", "Copied Workflow", "Workflow copied from JIRA default");
        this.assertTextPresent("Copied Workflow");
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").addTransition("Open", TRANSITION_NAME_1, TRANSITION_DESC, "Closed", TRANSITION_FIELD_SCREEN).addTransition("Open", TRANSITION_NAME_2, TRANSITION_DESC, "Closed", TRANSITION_FIELD_SCREEN);
    }

    public void testTransitionView1() {
        this.copyWorkflowAndAddTransitions();
        this.administration.workflows().goTo().workflowSteps("Copied Workflow");
        this.clickLinkWithText(TRANSITION_NAME_1);
        this.assertTextPresent("None - it will happen instantly");
        this.clickLink("edit_transition");
        this.assertFormElementEquals("view", "");
        this.submit("Update");
        this.assertTextPresent("None - it will happen instantly");
        this.clickLink("edit_transition");
        this.assertFormElementEquals("view", "");
        this.selectOption("view", "Default Screen");
        this.assertFormElementEquals("view", "1");
        this.submit("Update");
        this.assertTextPresent("Default Screen");
        this.clickLink("edit_transition");
        this.assertFormElementEquals("view", "1");
        this.submit("Update");
        this.assertTextPresent("Default Screen");
        this.clickLink("edit_transition");
        this.assertFormElementEquals("view", "1");
        this.selectOption("view", "Workflow Screen");
        this.assertFormElementEquals("view", "2");
        this.submit("Update");
        this.assertTextPresent("Workflow Screen");
        this.clickLink("edit_transition");
        this.assertFormElementEquals("view", "2");
        this.submit("Update");
        this.assertTextPresent("Workflow Screen");
        this.clickLink("edit_transition");
        this.assertFormElementEquals("view", "2");
        this.selectOption("view", TRANSITION_FIELD_SCREEN);
        this.assertFormElementEquals("view", "");
        this.submit("Update");
        this.assertTextPresent("None - it will happen instantly");
        this.clickLink("edit_transition");
        this.assertFormElementEquals("view", "");
        this.submit("Update");
        this.assertTextPresent("None - it will happen instantly");
    }

    public void testTransitionView2() {
        this.copyWorkflowAndAddTransitions();
        this.administration.workflows().goTo().workflowSteps("Copied Workflow");
        this.clickLinkWithText(TRANSITION_NAME_2);
        this.assertTextPresent("None - it will happen instantly");
        this.clickLink("edit_transition");
        this.assertFormElementEquals("view", "");
        this.selectOption("destinationStep", "Closed");
        this.assertFormElementEquals("view", "");
        this.submit("Update");
        this.assertTextPresent("None - it will happen instantly");
        this.clickLink("edit_transition");
        this.assertFormElementEquals("view", "");
        this.selectOption("view", "Resolve Issue Screen");
        this.assertFormElementEquals("view", "3");
        this.submit("Update");
        this.assertTextPresent("Resolve Issue Screen");
        this.clickLink("edit_transition");
        this.assertFormElementEquals("view", "3");
        this.selectOption("destinationStep", "Resolved");
        this.assertFormElementEquals("view", "3");
        this.submit("Update");
        this.assertTextPresent("Resolve Issue Screen");
        this.clickLink("edit_transition");
        this.assertFormElementEquals("view", "3");
        this.selectOption("view", TRANSITION_FIELD_SCREEN);
        this.assertFormElementEquals("view", "");
        this.submit("Update");
        this.assertTextPresent("None - it will happen instantly");
    }
}

