/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.SearchRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestWorkflowTransitionReindexing
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.backdoor.restoreBlankInstance();
    }

    public void testReIndexingFieldsSetDuringTransition() throws Exception {
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", true);
        this.backdoor.screens().addFieldToScreen("Resolve Issue Screen", "Log Work");
        this.backdoor.screens().addFieldToScreen("Resolve Issue Screen", "Summary");
        this.backdoor.screens().addFieldToScreen("Resolve Issue Screen", "Comment");
        JiraRestClient restClient = this.createRestClient();
        IssueRestClient issueClient = restClient.getIssueClient();
        IssueInput issueInput = new IssueInputBuilder("HSP", Long.valueOf(1L)).setSummary("new issue").setDescription("issue description").build();
        Issue issue = (Issue)issueClient.getIssue(((BasicIssue)issueClient.createIssue(issueInput).claim()).getKey()).claim();
        Iterable transitions = (Iterable)issueClient.getTransitions(issue).claim();
        Transition resolveIssue = (Transition)Iterables.find((Iterable)transitions, (Predicate)new Predicate<Transition>(){

            public boolean apply(Transition transition) {
                return transition.getName().contains("Resolve");
            }
        });
        this.navigation.issue().gotoIssue(issue.getKey());
        this.tester.clickLink("action_id_" + resolveIssue.getId());
        this.tester.setWorkingForm("issue-workflow-transition");
        String changedSummaryValue = "changed summary";
        this.tester.setFormElement("comment", "some random comment");
        this.tester.setFormElement("worklog_timeLogged", "2h");
        this.tester.setFormElement("summary", changedSummaryValue);
        this.tester.submit();
        SearchRestClient searchClient = restClient.getSearchClient();
        SearchResult searchResult = (SearchResult)searchClient.searchJql("timespent > 1h").claim();
        Assert.assertThat((Object)searchResult.getIssues(), (Matcher)Matchers.contains(this.issue(issue.getKey())));
        searchResult = (SearchResult)searchClient.searchJql("summary ~ \"" + changedSummaryValue + "\"").claim();
        Assert.assertThat((Object)searchResult.getIssues(), (Matcher)Matchers.contains(this.issue(issue.getKey())));
        searchResult = (SearchResult)searchClient.searchJql("summary ~ issue").claim();
        Assert.assertThat((Object)searchResult.getIssues(), (Matcher)Matchers.emptyIterable());
        searchResult = (SearchResult)searchClient.searchJql("comment ~ random").claim();
        Assert.assertThat((Object)searchResult.getIssues(), (Matcher)Matchers.contains(this.issue(issue.getKey())));
    }

    private Matcher<Issue> issue(final String issueKey) {
        return new TypeSafeMatcher<Issue>(){

            protected boolean matchesSafely(Issue issue) {
                return issue.getKey().equals(issueKey);
            }

            public void describeTo(Description description) {
                description.appendText("Issue").appendValue((Object)issueKey).appendText("not on the list");
            }
        };
    }
}

