/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.fugue.Iterables;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.api.domain.util.ErrorCollection;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import java.io.IOException;
import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY, Category.REFERENCE_PLUGIN, Category.PERMISSIONS, Category.WORKFLOW})
public class TestWorkflowTransitionPermission
extends FuncTestCase {
    private static final String TRANSITION_ISSUE_PERMISSION_OVERRIDE_MODULE = "com.atlassian.jira.dev.reference-plugin:brad.odlaw.cant.transition.issue";
    private static final String JIRA_USERS_GROUP = "jira-users";
    private static final long DEFAULT_PERMISSION_SCHEME_ID = 0L;
    private static final String PAUL_WITH_TRANSITION_POWER = "paul-with-transition-power";
    private static final String MARK_CANT_PERFORM_TRANSITION = "mark-cant-perform-transition";
    private static final String JIRA_DEVELOPERS_GROUP = "jira-developers";
    private static final int START_PROGRESS_TRANSITION_ID = 4;
    private static final String START_PROGRESS_TRANSITION_NAME = "Start Progress";
    private static final String BRAD = "brad_the_odlaw";
    private final AsynchronousJiraRestClientFactory restClientFactory = new AsynchronousJiraRestClientFactory();
    private IssueCreateResponse testIssue;
    private JiraRestClient jiraRestClient;

    @Override
    protected void setUpTest() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.TRANSITION_ISSUES, JIRA_USERS_GROUP);
        this.backdoor.usersAndGroups().addUser(BRAD, BRAD, BRAD, "odlaw@atlassiqan.com").addUserToGroup(BRAD, JIRA_DEVELOPERS_GROUP);
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.TRANSITION_ISSUES, BRAD);
        this.backdoor.usersAndGroups().addUser(MARK_CANT_PERFORM_TRANSITION).addUserToGroup(MARK_CANT_PERFORM_TRANSITION, JIRA_DEVELOPERS_GROUP);
        this.backdoor.usersAndGroups().addUser(PAUL_WITH_TRANSITION_POWER).addUserToGroup(PAUL_WITH_TRANSITION_POWER, JIRA_DEVELOPERS_GROUP);
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.TRANSITION_ISSUES, PAUL_WITH_TRANSITION_POWER);
        this.testIssue = this.backdoor.issues().createIssue("HSP", "issue summary");
    }

    @Override
    protected void tearDownTest() {
        this.closeRestClient();
    }

    public void testShouldNotBeAbleToPerformTransitionWhenTransitionPermissionIsVetoed() throws IOException {
        this.initializeRestClient(BRAD);
        this.backdoor.plugins().disablePluginModule(TRANSITION_ISSUE_PERMISSION_OVERRIDE_MODULE);
        Iterable<Transition> issueTransitionsBeforeVeto = this.getIssueTransitions(this.jiraRestClient, this.testIssue.key());
        Assert.assertThat(issueTransitionsBeforeVeto, (Matcher)Matchers.not((Matcher)Matchers.emptyIterable()));
        this.backdoor.plugins().enablePluginModule(TRANSITION_ISSUE_PERMISSION_OVERRIDE_MODULE);
        Assert.assertThat(this.getIssueTransitions(this.jiraRestClient, this.testIssue.key()), (Matcher)Matchers.emptyIterable());
        Transition transition = (Transition)Iterables.first(issueTransitionsBeforeVeto).get();
        this.assertCannotExecuteTransitionViaRestClient(transition.getId(), transition.getName());
    }

    public void testShouldBeAbleToPerformTransitionWhenTransitionPermissionIsGranted() {
        this.navigation.login(PAUL_WITH_TRANSITION_POWER);
        this.navigation.issue().closeIssue(this.testIssue.key(), "Fixed", null);
        this.initializeRestClient(PAUL_WITH_TRANSITION_POWER);
        this.assertIssueStatusEquals(this.testIssue.key(), "Closed");
    }

    public void testShouldNotBeAbleToPerformTransitionWhenTransitionPermissionIsRevokedUsingTransitionDialogWithComment() {
        this.navigation.login(MARK_CANT_PERFORM_TRANSITION);
        try {
            this.navigation.issue().closeIssue(this.testIssue.key(), "Fixed", "I would like to close this issue, but I can't!");
            TestWorkflowTransitionPermission.fail((String)"Close issue should throw exception, did permission check failed?");
        }
        catch (AssertionError assertionError) {
            TestWorkflowTransitionPermission.assertEquals((String)"Unable to find link with id [action_id_2]", (String)((Throwable)((Object)assertionError)).getMessage());
        }
    }

    public void testShouldNotBeAbleToPerformTransitionWhenTransitionPermissionIsRevokedUsingTransitionWithoutDialog() throws IOException {
        this.navigation.login(MARK_CANT_PERFORM_TRANSITION);
        try {
            this.navigation.issue().performIssueActionWithoutDetailsDialog(this.testIssue.key(), START_PROGRESS_TRANSITION_NAME);
            TestWorkflowTransitionPermission.fail((String)"Start progress should throw exception, did permission check failed?");
        }
        catch (AssertionError assertionError) {
            TestWorkflowTransitionPermission.assertEquals((String)"Link with text [Start Progress] not found in response.", (String)((Throwable)((Object)assertionError)).getMessage());
        }
    }

    public void testShouldNotSeeAnyTransitionsWhenTransitionPermissionIsRevoked() throws IOException {
        this.navigation.login(MARK_CANT_PERFORM_TRANSITION);
        this.navigation.issue().assignIssue(this.testIssue.key(), null, MARK_CANT_PERFORM_TRANSITION);
        this.initializeRestClient(MARK_CANT_PERFORM_TRANSITION);
        Iterable<Transition> issueTransitions = this.getIssueTransitions(this.jiraRestClient, this.testIssue.key());
        Assert.assertThat(issueTransitions, (Matcher)Matchers.emptyIterable());
        this.assertCannotExecuteTransitionViaRestClient(4, START_PROGRESS_TRANSITION_NAME);
    }

    public void testShouldBeAbleToStartProgressViaRestApiWhenTransitionPermissionIsGranted() throws IOException {
        this.navigation.login(PAUL_WITH_TRANSITION_POWER);
        this.navigation.issue().assignIssue(this.testIssue.key(), null, PAUL_WITH_TRANSITION_POWER);
        this.initializeRestClient(PAUL_WITH_TRANSITION_POWER);
        Iterable<Transition> issueTransitions = this.getIssueTransitions(this.jiraRestClient, this.testIssue.key());
        Assert.assertThat(issueTransitions, (Matcher)Matchers.not((Matcher)Matchers.emptyIterable()));
        this.executeTransition(this.jiraRestClient, this.testIssue.key(), new TransitionInput(4));
        this.assertIssueStatusEquals(this.testIssue.key(), "In Progress");
    }

    private void assertIssueStatusEquals(String issueKey, String expectedStatus) {
        String issueStatus = ((Issue)this.jiraRestClient.getIssueClient().getIssue(issueKey).claim()).getStatus().getName();
        TestWorkflowTransitionPermission.assertEquals((String)expectedStatus, (String)issueStatus);
    }

    private void assertCannotExecuteTransitionViaRestClient(int transitionId, String transitionName) {
        try {
            this.executeTransition(this.jiraRestClient, this.testIssue.key(), new TransitionInput(transitionId));
            TestWorkflowTransitionPermission.fail((String)"We expected exception here - it (probably) mean that user was able to perform permission!");
        }
        catch (RestClientException e) {
            TestWorkflowTransitionPermission.assertEquals((String)"Status code should be 400", (Object)400, (Object)e.getStatusCode().orNull());
            String expectedMessage = "It seems that you have tried to perform a workflow operation (" + transitionName + ") that is not valid for the current state of this " + "issue (" + this.testIssue.key() + "). The likely cause is that somebody has changed the " + "issue recently, please look at the issue history for details.";
            Assert.assertThat((Object)((ErrorCollection)e.getErrorCollections().iterator().next()).getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{expectedMessage}));
        }
    }

    private Iterable<Transition> getIssueTransitions(JiraRestClient jiraRestClient, String issueKey) {
        IssueRestClient issueClient = jiraRestClient.getIssueClient();
        Issue restClientIssue = (Issue)issueClient.getIssue(issueKey).claim();
        return (Iterable)issueClient.getTransitions(restClientIssue).claim();
    }

    private void executeTransition(JiraRestClient jiraRestClient, String issueKey, TransitionInput transition) {
        IssueRestClient issueClient = jiraRestClient.getIssueClient();
        Issue restClientIssue = (Issue)issueClient.getIssue(issueKey).claim();
        issueClient.transition(restClientIssue, transition).claim();
    }

    private void initializeRestClient(String user) {
        this.closeRestClient();
        this.jiraRestClient = this.restClientFactory.createWithBasicHttpAuthentication(URI.create(this.environmentData.getBaseUrl().toString()), user, user);
    }

    private void closeRestClient() {
        if (this.jiraRestClient != null) {
            try {
                this.jiraRestClient.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.jiraRestClient = null;
            }
        }
    }
}

