/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.admin.ViewWorkflows;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.google.common.collect.Iterables;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestWorkflowNameEditing
extends JIRAWebTest {
    public TestWorkflowNameEditing(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.administration.restoreData("TestWorkflowNameEditing.xml");
    }

    @Override
    public void tearDown() {
        this.administration.restoreBlankInstance();
        super.tearDown();
    }

    public void testSystemWorkflowIsNotEditable() {
        TestWorkflowNameEditing.assertFalse((boolean)this.administration.workflows().goTo().isEditable("jira"));
    }

    public void testAnActiveWorkflowIsEditableGivenADraftHasNotBeenCreatedForIt() {
        TestWorkflowNameEditing.assertTrue((boolean)this.administration.workflows().goTo().isEditable("Active workflow"));
    }

    public void testAnActiveWorkflowIsEditableGivenADraftHasBeenCreatedForIt() {
        this.administration.workflows().goTo().createDraft("Active workflow");
        TestWorkflowNameEditing.assertTrue((boolean)this.administration.workflows().goTo().isEditable("Active workflow"));
    }

    public void testAnInactiveWorkflowIsEditableGivenItHasNoAssignedSchemes() {
        TestWorkflowNameEditing.assertTrue((boolean)this.administration.workflows().goTo().isEditable("editable with no scheme"));
    }

    public void testAnInactiveWorkflowIsEditableGivenItHasAssignedSchemes() {
        TestWorkflowNameEditing.assertTrue((boolean)this.administration.workflows().goTo().isEditable("editable workflow"));
    }

    public void testEditInactiveWorkflowWithScheme() throws SAXException {
        this.administration.workflows().goTo().edit("editable workflow").rename().setNameTo("edited with a scheme").setDescriptionTo("edited with a scheme").submit();
        this.administration.workflows().goTo();
        this.tester.assertTextPresent("edited with a scheme");
        this.tester.assertTextNotPresent("editable workflow");
        this.associateWorkFlowSchemeToProject("monkey", "scheme with editable flow");
        this.waitForSuccessfulWorkflowSchemeMigration("monkey", "scheme with editable flow");
        this.associateWorkFlowSchemeToProject("neanderthal", "scheme with renamed workflow");
        this.waitForSuccessfulWorkflowSchemeMigration("neanderthal", "scheme with renamed workflow");
        this.assertAddingIssueForModifiedWorkflow("monkey", "New Feature", "MONKEY new feature issue of the workflow that was renamed");
        this.assertAddingIssueForModifiedWorkflow("monkey", "Task", "MONKEY task issue of the workflow that was renamed");
        this.assertAddingIssueForUnModifiedWorkflow("monkey", "Bug", "MONKEY bug issue of the workflow that was NOT renamed");
        this.assertAddingIssueForUnModifiedWorkflow("monkey", "Improvement", "MONKEY improvement issue of the workflow that was NOT renamed");
        this.assertAddingIssueForModifiedWorkflow("neanderthal", "Bug", "NEO bug issue of the workflow that was renamed");
        this.assertAddingIssueForModifiedWorkflow("neanderthal", "Improvement", "NEO improvement issue of the workflow that was renamed");
        this.assertAddingIssueForModifiedWorkflow("neanderthal", "New Feature", "NEO new feature issue of the workflow that was renamed");
        this.assertAddingIssueForModifiedWorkflow("neanderthal", "Task", "NEO task issue of the workflow that was renamed");
    }

    private void assertAddingIssueForUnModifiedWorkflow(String project, String issueType, String summary) {
        this.navigation.issue().createIssue(project, issueType, summary);
        this.tester.assertTextNotPresent("RESOLVE WITH EDITED WO...");
        this.tester.assertLinkPresentWithText("Start Progress");
        this.tester.assertLinkPresentWithText("Resolve Issue");
        this.tester.assertLinkPresentWithText("Close Issue");
        this.tester.assertTextPresent("Open");
        this.tester.assertTextNotPresent("In Progress");
        this.tester.clickLink("action_id_4");
        this.tester.assertTextPresent("In Progress");
        this.tester.assertTextNotPresent("Open");
    }

    private void assertAddingIssueForModifiedWorkflow(String project, String issueType, String summary) {
        this.navigation.issue().createIssue(project, issueType, summary);
        this.tester.assertLinkPresentWithText("RESOLVE WITH EDITED WO...");
        this.tester.assertTextPresent("Open");
        Assert.assertThat((Object)this.tester.getDialog().getElement("stalker").getTextContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Resolved")));
        this.tester.clickLink("action_id_11");
        this.tester.assertTextPresent("Resolved");
        Assert.assertThat((Object)this.tester.getDialog().getElement("stalker").getTextContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Open")));
    }

    public void testDefaultSystemWorkflowIsNotEditableViaUrlAccess() {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/workflows/EditWorkflow.jspa?workflowMode=live&workflowName=jira"));
        this.assertWorkflowIsNotEditable();
    }

    public void testActiveWorkflowsAreNotEditable() {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/workflows/EditWorkflow.jspa?workflowMode=live&workflowName=Active+workflow"));
        this.assertWorkflowIsNotEditable();
    }

    public void testEditWorkflowNameValidation() {
        this.administration.workflows().goTo().edit("editable workflow").rename().setNameTo("").submit();
        this.tester.assertTextPresent("You must specify a workflow name.");
        this.administration.workflows().goTo().edit("editable workflow").rename().setNameTo("Active workflow").submit();
        this.tester.assertTextPresent("A workflow with this name already exists.");
        this.administration.workflows().goTo().edit("editable workflow").rename().setNameTo("non-ascii char: \u1234").submit();
        this.tester.assertTextPresent("Please use only ASCII characters for the workflow name.");
    }

    private void assertWorkflowIsNotEditable() {
        this.tester.assertTextPresent("Workflow cannot be edited as it is not editable.");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Edit Workflow");
        this.tester.assertTextPresent("Workflow cannot be edited as it is not editable.");
        this.tester.setFormElement("newWorkflowName", "name change");
        this.tester.setFormElement("description", "desc change");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Edit Workflow");
        this.tester.assertTextPresent("Workflow cannot be edited as it is not editable.");
    }

    public void testEditDraftWorkflow() {
        this.administration.workflows().goTo().createDraft("Active workflow");
        TestWorkflowNameEditing.assertFalse((boolean)this.administration.workflows().goTo().edit("Active workflow").rename().isNameEditable());
        this.administration.workflows().goTo().edit("Active workflow").rename().setDescriptionTo("well not really since its a draft").submit();
        TestWorkflowNameEditing.assertTrue((boolean)Iterables.any((Iterable)Iterables.filter((Iterable)((Object)this.administration.workflows().goTo().active()), ViewWorkflows.WorkflowItemsList.Predicates.byName("Active workflow")), ViewWorkflows.WorkflowItemsList.Predicates.byDescription("This workflow is active")));
        this.administration.workflows().goTo().edit("Active workflow");
        this.tester.assertTextPresent("well not really since its a draft");
    }
}

