/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.backdoor.ProjectControlExt;
import com.atlassian.jira.functest.framework.backdoor.WorkflowsControlExt;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.WorkflowSchemesControl;
import com.atlassian.jira.webtests.ztests.workflow.AbstractTestWorkflowSchemeMigration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestWorkflowMigration
extends AbstractTestWorkflowSchemeMigration {
    public TestWorkflowMigration(String name) {
        super(name);
    }

    public void testDrafWorkflowRemovedWhenInactive() {
        this.getBackdoor().restoreBlankInstance();
        String workflowName = "WorkflowWithDraft";
        WorkflowsControlExt workflowControl = this.getBackdoor().workflow();
        workflowControl.createWorkflow("WorkflowWithDraft");
        WorkflowSchemesControl workflowSchemesControl = this.getBackdoor().workflowSchemes();
        WorkflowSchemeData scheme = workflowSchemesControl.createScheme(new WorkflowSchemeData().setName("WorkflowWithDraft").setMapping("Bug", "WorkflowWithDraft"));
        String projectKey = "TDWC";
        String projectName = "testDrafWorkflowRemovedWhenInactive";
        ProjectControlExt projectControl = this.getBackdoor().project();
        projectControl.addProject("testDrafWorkflowRemovedWhenInactive", "TDWC", "admin");
        projectControl.setWorkflowScheme("TDWC", scheme.getId());
        workflowControl.createDraftOfWorkflow("WorkflowWithDraft");
        String targetSchemeName = "WorkflowWithDraftTarget";
        workflowSchemesControl.createScheme(new WorkflowSchemeData().setName("WorkflowWithDraftTarget").setMapping("Bug", "jira"));
        this.administration.project().associateWorkflowScheme("testDrafWorkflowRemovedWhenInactive", "WorkflowWithDraftTarget", Collections.emptyMap(), true);
        WorkflowsControlExt.Workflow workflow = workflowControl.getWorkflowDetailed("WorkflowWithDraft");
        TestWorkflowMigration.assertFalse((String)"Workflow should no longer have a draft.", (boolean)workflow.isHasDraft());
        workflow = workflowControl.getWorkflowDetailed("Copy of WorkflowWithDraft");
        TestWorkflowMigration.assertNotNull((String)"Workflow draft has been made its own scheme?", (Object)workflow);
        TestWorkflowMigration.assertEquals((String)"Description should be valid.", (String)String.format("(This copy was automatically generated from a draft, when workflow '%s' was made inactive.)", "WorkflowWithDraft"), (String)workflow.getDescription());
    }

    public void testWorkflowMigration() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTest.xml");
        this.associateScheme();
        this.assertStandardIssues("TST");
    }

    public void testWorkflowMigrationHalfMigratedData() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTestBrokenHalfWay.xml");
        this.associateScheme();
        this.assertIssuesMigratedAndChangeHistory("TST");
    }

    public void testWorkflowMigrationWithUnupdatedIssue() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTestIssueWithUnupdatedIssue.xml");
        this.associateScheme();
        this.assertIssuesMigratedAndChangeHistory("TST");
    }

    public void testWorkflowMigrationWithUnupdatedWorkflowScheme() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTestUnchangedScheme.xml");
        this.associateScheme();
        this.assertIssuesAfterMigrationWithUnupdatedWorkflowScheme();
    }

    public void testWorkflowMigrationWithRemovedWorkflowScheme() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTestRemovedWorkflowScheme.xml");
        HashMap<String, String> statusMapping = new HashMap<String, String>();
        statusMapping.put("mapping_1_1", "Custom Status 3");
        statusMapping.put("mapping_1_3", "Resolved");
        statusMapping.put("mapping_1_6", "Custom Status 4");
        statusMapping.put("mapping_1_4", "Custom Status 3");
        statusMapping.put("mapping_4_1", "Custom Status 3");
        statusMapping.put("mapping_4_3", "Resolved");
        statusMapping.put("mapping_4_6", "Custom Status 4");
        statusMapping.put("mapping_4_4", "Custom Status 3");
        statusMapping.put("mapping_2_1", "Custom Status 3");
        statusMapping.put("mapping_2_3", "Resolved");
        statusMapping.put("mapping_2_6", "Custom Status 4");
        statusMapping.put("mapping_2_4", "Custom Status 3");
        this.associateScheme(statusMapping);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Open").addTransitions("Start Progress", "Resolve Issue", "Close Issue").addHistoryItems(TestWorkflowMigration.item("Workflow", "Source Workflow 1", "jira")).assertIssue(this.getIssue("TST-1"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Open").addTransitions("Start Progress", "Resolve Issue", "Close Issue").addHistoryItems(TestWorkflowMigration.item("Workflow", "Source Workflow 1", "jira")).assertIssue(this.getIssue("TST-2"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Resolved").addTransitions("Go 4").addHistoryItems(TestWorkflowMigration.item("Workflow", "jira", "Destinatiom Workflow")).assertIssue(this.getIssue("TST-3"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 4").addTransitions("Go 3").addHistoryItems(TestWorkflowMigration.item("Workflow", "jira", "Destinatiom Workflow")).assertIssue(this.getIssue("TST-4"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 3").addTransitions("Resolve").addHistoryItems(TestWorkflowMigration.item("Workflow", "jira", "Destinatiom Workflow")).assertIssue(this.getIssue("TST-5"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 4").addTransitions("Go 3").addHistoryItems(TestWorkflowMigration.item("Workflow", "jira", "Destinatiom Workflow")).assertIssue(this.getIssue("TST-6"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 4").addTransitions("Go 3").addHistoryItems(TestWorkflowMigration.item("Workflow", "jira", "Destinatiom Workflow")).assertIssue(this.getIssue("TST-7"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Resolved").addTransitions("Go 4").addHistoryItems(TestWorkflowMigration.item("Workflow", "jira", "Destinatiom Workflow")).assertIssue(this.getIssue("TST-8"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Closed").addTransitions("Reopen Issue").addHistoryItems(TestWorkflowMigration.item("Workflow", "Source Workflow 1", "jira")).assertIssue(this.getIssue("TST-9"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 3").addTransitions("Resolve").addHistoryItems(TestWorkflowMigration.item("Workflow", "jira", "Destinatiom Workflow")).assertIssue(this.getIssue("TST-10"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 3").addTransitions("Resolve").addHistoryItems(TestWorkflowMigration.item("Workflow", "jira", "Destinatiom Workflow")).assertIssue(this.getIssue("TST-11"), false);
    }

    private void associateScheme() {
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        this.associateScheme(statusMapping);
    }

    private void associateScheme(Map<String, String> statusMapping) {
        this.associateWorkFlowSchemeToProject("Test Project", "Destination Workflow Scheme", statusMapping);
        this.waitForSuccessfulWorkflowSchemeMigration("Test Project", "Destination Workflow Scheme");
    }

    public void testWorkflowMigrationHalfMigratedDataNewDestination() throws SAXException {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationHalfMigratedDataNewDestination.xml");
        this.gotoPage("/secure/project/SelectProjectWorkflowScheme!default.jspa?projectId=10010");
        this.assertTextNotPresent("There are currently no workflow schemes setup.");
        this.getAssertions().getLinkAssertions().assertLinkNotPresentWithExactText("//div[@class='aui-page-panel-main']", "Add");
        String destinationSchemeName = "Homosapien Destination Scheme";
        this.selectOption("schemeId", destinationSchemeName);
        this.submit("Associate");
        this.assertTextPresent("Step 2 of 3");
        this.assertTextPresent("Affected issues: 4 of 8");
        this.assertTextPresent("Affected issues: 8 of 16");
        this.assertTextPresent("Affected issues: 2 of 8");
        this.assertMappingAndSelectOptionsForHalfMigratedDataNewDestination();
        this.submit("Associate");
        this.waitForSuccessfulWorkflowSchemeMigration("homosapien", destinationSchemeName);
        this.assertIssuesInHomosapienProjectAfterHalfMigratedDataNewDestination();
        this.checkIssuesInTestProjectAfterHalfMigratedDataNewDestination();
    }

    public void testIssueVerifier() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTestIssueVerifier.xml");
        this.administration.project().associateWorkflowScheme("Test Project", "Destination Workflow Scheme", Collections.emptyMap(), false);
        this.waitForFailedMigration();
        this.assertIssueVerifierErrorMessages("TST");
    }

    public void testMultipleActiveWorkflowErrorMessageNotPresentInEnterprise() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTest.xml");
        this.gotoPage("secure/admin/workflows/ListWorkflows.jspa");
        this.assertTextNotPresent("An error has occured during workflow activation and the result is multiple active workflows");
    }

    public void testMultiAdminTaskProgressFlow() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTwoAdmins.xml");
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        this.administration.project().associateWorkflowScheme("Test Project", "Destination Workflow Scheme", statusMapping, false);
        long taskId = this.getSubmittedTaskId();
        this.waitForTaskAcknowledgement(taskId);
        this.assertTextPresent("input type=\"submit\" name=\"Acknowledge\"");
        this.assertTextNotPresent("input type=\"submit\" name=\"Done\"");
        this.validateProgressBarUI("Acknowledge");
        this.navigation.logout();
        this.navigation.login("admin2", "admin2");
        this.navigation.gotoAdmin();
        this.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep3.jspa?projectId=10000&taskId=" + taskId + "&schemeId=10001");
        this.validateProgressBarUI("Done");
        this.assertTextNotPresent("input type=\"submit\" name=\"Acknowledge\"");
        this.assertTextPresent("input type=\"submit\" name=\"Done\"");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.gotoAdmin();
        this.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep3.jspa?projectId=10000&taskId=" + taskId + "&schemeId=10001");
        this.assertTextPresent("input type=\"submit\" name=\"Acknowledge\"");
        this.assertTextNotPresent("input type=\"submit\" name=\"Done\"");
        this.validateProgressBarUI("Acknowledge");
        this.submit("Acknowledge");
        this.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep3.jspa?projectId=10000&taskId=" + taskId + "&schemeId=10001");
        this.assertTextPresent("The task could not be found. Perhaps it has finished and has been acknowledged?");
        this.assertTextPresent("input type=\"submit\" name=\"Done\"");
    }

    public void testMigrateSchemeWithDraft() {
        this.backdoor.restoreDataFromResource("WorkflowMigrationTestWithDrafts.xml");
        WorkflowSchemeData draft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("homosapien");
        this.administration.project().associateWorkflowScheme("homosapien", "Two");
        WorkflowSchemeData copiedScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound("Copy of One");
        TestWorkflowMigration.assertNotNull((Object)copiedScheme);
        TestWorkflowMigration.assertFalse((boolean)copiedScheme.isActive());
        TestWorkflowMigration.assertEquals((String)"(This copy was automatically generated from a draft, when workflow scheme 'One' was made inactive.)", (String)copiedScheme.getDescription());
        TestWorkflowMigration.assertEquals((Object)draft.getMappings(), (Object)copiedScheme.getMappings());
        this.administration.project().associateWorkflowScheme("monkey", "One");
        draft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("monkey");
        TestWorkflowMigration.assertNull((Object)draft);
    }

    public void testMigrateSchemeWithDraftUsedByAnotherProject() {
        this.backdoor.restoreDataFromResource("WorkflowMigrationTestWithDrafts.xml");
        this.administration.project().associateWorkflowScheme("monkey", "One");
        WorkflowSchemeData homosapienDraft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("homosapien");
        this.administration.project().associateWorkflowScheme("homosapien", "Two");
        WorkflowSchemeData copiedScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound("Copy of One");
        TestWorkflowMigration.assertNull((Object)copiedScheme);
        WorkflowSchemeData monkeyDraft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("monkey");
        TestWorkflowMigration.assertNotNull((Object)monkeyDraft);
        TestWorkflowMigration.assertEquals((String)monkeyDraft.getName(), (String)homosapienDraft.getName());
        TestWorkflowMigration.assertEquals((String)monkeyDraft.getDescription(), (String)homosapienDraft.getDescription());
        TestWorkflowMigration.assertEquals((Object)monkeyDraft.getMappings(), (Object)homosapienDraft.getMappings());
    }

    public void testMigrateSchemeWithDraftWithTheSameNameAsExistingWorkflowScheme() {
        this.backdoor.restoreDataFromResource("WorkflowMigrationTestWithDrafts.xml");
        this.backdoor.workflowSchemes().createScheme(new WorkflowSchemeData().setName("Copy of One"));
        WorkflowSchemeData draft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("homosapien");
        this.administration.project().associateWorkflowScheme("homosapien", "Two");
        WorkflowSchemeData copiedScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound("Copy 2 of One");
        TestWorkflowMigration.assertNotNull((Object)copiedScheme);
        TestWorkflowMigration.assertFalse((boolean)copiedScheme.isActive());
        TestWorkflowMigration.assertEquals((String)"(This copy was automatically generated from a draft, when workflow scheme 'One' was made inactive.)", (String)copiedScheme.getDescription());
        TestWorkflowMigration.assertEquals((Object)draft.getMappings(), (Object)copiedScheme.getMappings());
        this.administration.project().associateWorkflowScheme("monkey", "One");
        draft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("monkey");
        TestWorkflowMigration.assertNull((Object)draft);
    }
}

