/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.assertions.TableAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.table.AndCell;
import com.atlassian.jira.webtests.table.EmptyCell;
import com.atlassian.jira.webtests.table.LinkCell;
import com.atlassian.jira.webtests.table.StrictTextCell;
import com.atlassian.jira.webtests.table.TextCell;
import java.text.SimpleDateFormat;
import java.util.Date;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestWorkflowEditor
extends JIRAWebTest {
    private static final String WORKFLOW_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE workflow PUBLIC \"-//OpenSymphony Group//DTD OSWorkflow 2.8//EN\" \"http://www.opensymphony.com/osworkflow/workflow_2_8.dtd\">\n<workflow>\n  <meta name=\"jira.update.author.key\">admin</meta>\n  <meta name=\"jira.description\"></meta>\n  <meta name=\"jira.updated.date\">1196830052833</meta>\n  <initial-actions>\n    <action id=\"1\" name=\"Create\">\n      <validators>\n        <validator name=\"\" type=\"class\">\n          <arg name=\"class.name\">com.atlassian.jira.workflow.validator.PermissionValidator</arg>\n          <arg name=\"permission\">Create Issue</arg>\n        </validator>\n      </validators>\n      <results>\n        <unconditional-result old-status=\"null\" status=\"open\" step=\"1\">\n          <post-functions>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.IssueCreateFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.IssueReindexFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>\n              <arg name=\"eventTypeId\">1</arg>\n            </function>\n          </post-functions>\n        </unconditional-result>\n      </results>\n    </action>\n  </initial-actions>\n  <steps>\n    <step id=\"1\" name=\"Open\">\n      <meta name=\"jira.status.id\">1</meta>\n    </step>\n  </steps>\n</workflow>";
    TableAssertions tableAssertions;

    public TestWorkflowEditor(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.administration.restoreData("TestWorkflowEditor.xml");
        this.tableAssertions = new TableAssertions(this.tester, this.environmentData);
    }

    public void testWorkflowListingEnterprise() {
        this.administration.workflows().goTo();
        TestWorkflowEditor.assertEquals((int)2, (int)this.getWebTableWithID("active-workflows-table").getRowCount());
        this.assertTableRowEquals(this.getWebTableWithID("active-workflows-table"), 0, new Object[]{new TextCell("Name"), new TextCell("Last modified"), new TextCell("Assigned Schemes"), new TextCell("Steps"), new TextCell("Operations")});
        this.assertTableHasMatchingRowFrom(this.getWebTableWithID("active-workflows-table"), 1, new Object[]{"Workflow1", new TextCell("05/Dec/07", "Administrator"), new LinkCell("EditWorkflowScheme.jspa?schemeId=10010", "WorkflowScheme_Workflow1"), new TextCell("1"), new AndCell(new XsrfLinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=Workflow1", "View"), new XsrfLinkCell("EditWorkflowDispatcher.jspa?wfName=Workflow1", "Edit"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=Workflow1", "Copy"))});
        this.assertTableHasMatchingRowFrom(this.getWebTableWithID("inactive-workflows-table"), 1, new Object[]{new TextCell(new String[]{"jira", "Read-only System Workflow", "Default", "The default JIRA workflow."}), new EmptyCell(), new EmptyCell(), new TextCell("5"), new AndCell(new XsrfLinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=jira", "View"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=jira", "Copy"))});
        this.assertTableHasMatchingRowFrom(this.getWebTableWithID("inactive-workflows-table"), 1, new Object[]{"Workflow2", new TextCell("05/Dec/07", "Administrator"), new EmptyCell(), new TextCell("1"), new AndCell(new XsrfLinkCell("EditWorkflowDispatcher.jsp?wfName=Workflow2", "Edit"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=Workflow2", "Copy"), new XsrfLinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=Workflow2", "Delete"))});
        this.assertTableHasMatchingRowFrom(this.getWebTableWithID("inactive-workflows-table"), 1, new Object[]{"Workflow3", new TextCell("05/Dec/07", "Administrator"), new EmptyCell(), new TextCell("1"), new AndCell(new XsrfLinkCell("EditWorkflowDispatcher.jsp?wfName=Workflow3", "Edit"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=Workflow3", "Copy"), new XsrfLinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=Workflow3", "Delete"))});
        this.clickLink("copy_Workflow3");
        this.assertTextPresent("Copy Workflow: Workflow3");
        this.setFormElement("newWorkflowName", "XX Copy Of Workflow3");
        this.setFormElement("description", "Description of Workflow 3 copy");
        this.submit("Update");
        SimpleDateFormat format = new SimpleDateFormat("dd/MMM/yy");
        this.administration.workflows().goTo();
        this.assertTextPresent("Workflows");
        this.assertTableHasMatchingRowFrom(this.getWebTableWithID("inactive-workflows-table"), 1, new Object[]{"XX Copy Of Workflow3", new TextCell(format.format(new Date()), "Administrator"), new EmptyCell(), new TextCell("1"), new AndCell(new XsrfLinkCell("EditWorkflowDispatcher.jsp?wfName=XX+Copy+Of+Workflow3", "Edit"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=XX+Copy+Of+Workflow3", "Copy"), new XsrfLinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=XX+Copy+Of+Workflow3", "Delete"))});
        this.clickLink("del_Workflow2");
        this.assertTextPresent("Delete Workflow");
        this.assertTextPresent("Confirm that you want to delete the workflow <strong>Workflow2</strong>.");
        this.assertLinkPresentWithText("do a full backup");
        this.assertLinkPresentWithText("export");
        this.submit("Delete");
        this.assertTextNotPresent("Workflow2");
        this.clickLink("edit_live_Workflow3");
        this.clickLink("xml_Workflow3");
        TestWorkflowEditor.assertEquals((int)200, (int)this.tester.getDialog().getResponse().getResponseCode());
        this.administration.workflows().goTo();
        this.clickLink("add-workflow");
        this.setFormElement("newWorkflowName", "ZZ This is a new Workflow!");
        this.setFormElement("description", "A new Workflow.");
        this.submit("Add");
        this.administration.workflows().goTo();
        this.assertTableHasMatchingRowFrom(this.getWebTableWithID("inactive-workflows-table"), 1, new Object[]{"ZZ This is a new Workflow!", new TextCell(format.format(new Date()), "Administrator"), new EmptyCell(), new TextCell("1"), new AndCell(new XsrfLinkCell("EditWorkflowDispatcher.jsp?wfName=ZZ+This+is+a+new+Workflow%21", "Edit"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=ZZ+This+is+a+new+Workflow%21", "Copy"), new XsrfLinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=ZZ+This+is+a+new+Workflow%21", "Delete"))});
        this.clickLinkWithText("Import XML");
        this.setFormElement("name", "ZZZ Imported workflow");
        this.setFormElement("description", "This was imported from XML!");
        this.setFormElement("workflowXML", "Invalid input");
        this.setFormElement("definition", "inline");
        this.submit("Import");
        this.assertTextPresent("Error parsing workflow XML");
        this.setFormElement("workflowXML", WORKFLOW_XML);
        this.submit("Import");
        this.assertTableHasMatchingRowFrom(this.getWebTableWithID("inactive-workflows-table"), 1, new Object[]{new TextCell("ZZZ Imported workflow", "This was imported from XML!"), new TextCell(format.format(new Date()), "Administrator"), new EmptyCell(), new TextCell("1"), new AndCell(new XsrfLinkCell("EditWorkflowDispatcher.jsp?wfName=ZZZ+Imported+workflow", "Edit"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=ZZZ+Imported+workflow", "Copy"), new XsrfLinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=ZZZ+Imported+workflow", "Delete"))});
    }

    public void testViewWorkflowSteps() {
        this.administration.workflows().goTo().workflowSteps("Workflow3");
        this.assertTextSequence(new String[]{"Edit Workflow", "Workflow3"});
        TestWorkflowEditor.assertEquals((int)2, (int)this.getWebTableWithID("steps_table").getRowCount());
        this.assertTableRowEquals(this.getWebTableWithID("steps_table"), 0, new Object[]{new TextCell("Step Name", "(id)"), new TextCell("Linked Status"), new TextCell("Transitions", "(id)"), new TextCell("Operations")});
        this.assertTableRowEquals(this.getWebTableWithID("steps_table"), 1, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=1", "Open"), new TextCell("(1)")), new TextCell("Open"), new StrictTextCell(""), new AndCell(new XsrfLinkCell("AddWorkflowTransition!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=1", "Add Transition"), new XsrfLinkCell("EditWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=1", "Edit"), new XsrfLinkCell("ViewWorkflowStepMetaAttributes.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=1", "View Properties"))});
        this.setFormElement("stepName", "");
        this.submit("Add");
        this.assertTextPresent("Step name must be specified.");
        this.setFormElement("stepName", "Resolved");
        this.selectOption("stepStatus", "Resolved");
        this.submit("Add");
        this.assertTableRowEquals(this.getWebTableWithID("steps_table"), 2, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Resolved"), new TextCell("(2)")), new TextCell("Resolved"), new StrictTextCell(""), new AndCell(new XsrfLinkCell("AddWorkflowTransition!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Add Transition"), new XsrfLinkCell("EditWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Edit"), new XsrfLinkCell("ViewWorkflowStepMetaAttributes.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "View Properties"), new XsrfLinkCell("DeleteWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Step"))});
        this.clickLink("add_trans_2");
        this.setFormElement("transitionName", "Re-open");
        this.setFormElement("description", "This transition re-opens a resolved issue.");
        this.selectOption("view", "Default Screen");
        this.submit("Add");
        this.assertTextSequence(new String[]{"Edit Workflow", "Workflow3"});
        this.assertTableRowEquals(this.getWebTableWithID("steps_table"), 2, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Resolved"), new TextCell("(2)")), new TextCell("Resolved"), new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow3&workflowTransition=11&workflowStep=2", "Re-open"), new TextCell("(11)", "Open")), new AndCell(new XsrfLinkCell("AddWorkflowTransition!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Add Transition"), new XsrfLinkCell("DeleteWorkflowTransitions!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Transitions"), new XsrfLinkCell("EditWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Edit"), new XsrfLinkCell("ViewWorkflowStepMetaAttributes.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "View Properties"), new XsrfLinkCell("DeleteWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Step"))});
        this.clickLink("edit_step_2");
        this.assertTextPresent("Update Workflow Step");
        this.assertTextPresent("This page allows you to update the <b>Resolved</b> step.");
        this.setFormElement("stepName", "Actually Closed");
        this.selectOption("stepStatus", "Closed");
        this.submit("Update");
        this.assertTableRowEquals(this.getWebTableWithID("steps_table"), 2, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Actually Closed"), new TextCell("(2)")), new TextCell("Closed"), new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow3&workflowTransition=11&workflowStep=2", "Re-open"), new TextCell("(11)", "Open")), new AndCell(new XsrfLinkCell("AddWorkflowTransition!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Add Transition"), new XsrfLinkCell("DeleteWorkflowTransitions!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Transitions"), new XsrfLinkCell("EditWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Edit"), new XsrfLinkCell("ViewWorkflowStepMetaAttributes.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "View Properties"), new XsrfLinkCell("DeleteWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Step"))});
        this.clickLink("add_trans_2");
        this.assertTextPresent("Add Workflow Transition");
        this.assertTextPresent("Create a transition from <b>Actually Closed</b> to another step.");
        this.setFormElement("transitionName", "Closed it again");
        this.setFormElement("description", "");
        this.selectOption("destinationStep", "Actually Closed");
        this.submit("Add");
        this.assertTableRowEquals(this.getWebTableWithID("steps_table"), 2, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Actually Closed"), new TextCell("(2)")), new TextCell("Closed"), new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow3&workflowTransition=11&workflowStep=2", "Re-open"), new TextCell("(11)", "Open"), new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow3&workflowTransition=21&workflowStep=2", "Closed it again"), new TextCell("21", "Closed")), new AndCell(new XsrfLinkCell("AddWorkflowTransition!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Add Transition"), new XsrfLinkCell("DeleteWorkflowTransitions!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Transitions"), new XsrfLinkCell("EditWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Edit"), new XsrfLinkCell("ViewWorkflowStepMetaAttributes.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "View Properties"))});
        this.clickLink("del_trans_2");
        this.assertTextPresent("Delete Workflow Transitions");
        this.assertTextPresent("Please select transitions to delete from the <b>Actually Closed</b> step.");
        this.selectOption("transitionIds", "Closed it again");
        this.submit("Delete");
        this.assertTextSequence(new String[]{"Edit Workflow", "Workflow3"});
        this.assertTextNotPresent("Closed it again");
    }

    public void testStepProperties() {
        this.administration.workflows().goTo().workflowSteps("Workflow2");
        this.tester.clickLinkWithText("View Properties");
        this.tester.assertTextPresent("View Workflow Step Properties: Open");
        this.tester.assertLinkPresentWithText("workflow steps");
        this.tester.assertTextPresent("There are currently no defined properties.");
        this.tester.assertTextPresent("Add New Property");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Key must be set.");
        this.tester.setFormElement("attributeKey", "test.key");
        this.tester.setFormElement("attributeValue", "");
        this.tester.submit("Add");
        this.tester.assertTextNotPresent("There are currently no defined properties.");
        TestWorkflowEditor.assertEquals((int)2, (int)this.getWebTableWithID("metas_table").getRowCount());
        this.tableAssertions.assertTableRowEquals(this.getWebTableWithID("metas_table"), 0, new Object[]{new TextCell("Property Key"), new TextCell("Property Value"), new TextCell("Operations")});
        this.tableAssertions.assertTableRowEquals(this.getWebTableWithID("metas_table"), 1, new Object[]{new TextCell("test.key"), new StrictTextCell(""), new XsrfLinkCell("RemoveWorkflowStepMetaAttribute.jspa?workflowName=Workflow2&workflowMode=live&workflowStep=1&attributeKey=test.key", "Delete")});
        this.tester.setFormElement("attributeKey", "another.key");
        this.tester.setFormElement("attributeValue", "This is a value.");
        this.tester.submit("Add");
        this.tester.assertTextNotPresent("There are currently no defined properties.");
        TestWorkflowEditor.assertEquals((int)3, (int)this.getWebTableWithID("metas_table").getRowCount());
        this.assertTableHasMatchingRow(this.getWebTableWithID("metas_table"), new Object[]{new TextCell("another.key"), new StrictTextCell("This is a value."), new XsrfLinkCell("RemoveWorkflowStepMetaAttribute.jspa?workflowName=Workflow2&workflowMode=live&workflowStep=1&attributeKey=another.key", "Delete")});
        this.tester.setFormElement("attributeKey", "another.key");
        this.tester.submit("Add");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("Key 'another.key' already exists.");
        this.tester.clickLink("del_meta_another.key");
        TestWorkflowEditor.assertEquals((int)2, (int)this.getWebTableWithID("metas_table").getRowCount());
        this.tester.assertTextNotPresent("another.key");
        this.tester.assertTextNotPresent("This is a value.");
    }

    public void testEditSingleStepAndTransition() {
        this.administration.workflows().goTo().workflowSteps("Workflow2").add("Resolved", "Resolved");
        this.navigation.clickLinkWithExactText("Open");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-page-header-main h2"), "Step: Open");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#orig_steps #view_transition_1"));
        this.assertLinkPresentWithSubString("view_transition_1", "ViewWorkflowTransition.jspa");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#orig_steps #view_transition_1"), "Create");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps .workflow-transition-not-found"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps .workflow-transition-not-found"), "No transitions");
        this.clickLink("add_transition");
        this.setFormElement("transitionName", "Resolve");
        this.selectOption("destinationStep", "Resolved");
        this.submit("Add");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-page-header-main h2"), "Step: Open");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#orig_steps #view_transition_1"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#orig_steps #view_transition_1"), "Create");
        this.assertLinkPresentWithSubString("view_transition_1", "ViewWorkflowTransition.jspa");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_11"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_11"), "Resolve");
        this.assertLinkPresentWithSubString("view_outbound_transition_11", "ViewWorkflowTransition.jspa");
        this.clickLink("add_transition");
        this.setFormElement("transitionName", "resolveitsomemore");
        this.selectOption("destinationStep", "Resolved");
        this.submit("Add");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#orig_steps #view_transition_1"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#orig_steps #view_transition_1"), "Create");
        this.assertLinkPresentWithSubString("view_transition_1", "ViewWorkflowTransition.jspa");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_11"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_11"), "Resolve");
        this.assertLinkPresentWithSubString("view_outbound_transition_11", "ViewWorkflowTransition.jspa");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_21"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_21"), "resolveitsomemore");
        this.assertLinkPresentWithSubString("view_outbound_transition_21", "ViewWorkflowTransition.jspa");
        this.clickLink("add_transition");
        this.setFormElement("transitionName", "opensomemore");
        this.submit("Add");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#orig_steps #view_transition_1"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#orig_steps #view_transition_1"), "Create");
        this.assertLinkPresentWithSubString("view_transition_1", "ViewWorkflowTransition.jspa");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#orig_steps #view_transition_31"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#orig_steps #view_transition_31"), "opensomemore");
        this.assertLinkPresentWithSubString("view_transition_31", "ViewWorkflowTransition.jspa");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_11"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_11"), "Resolve");
        this.assertLinkPresentWithSubString("view_outbound_transition_11", "ViewWorkflowTransition.jspa");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_21"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_21"), "resolveitsomemore");
        this.assertLinkPresentWithSubString("view_outbound_transition_21", "ViewWorkflowTransition.jspa");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_31"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_transition_31"), "opensomemore");
        this.assertLinkPresentWithSubString("view_outbound_transition_31", "ViewWorkflowTransition.jspa");
        this.clickLinkWithText("resolveitsomemore");
        this.assertTextPresent("Transition: resolveitsomemore");
        this.assertTextSequence(new String[]{"Screen", "None", "it will happen instantly"});
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#orig_steps #view_inbound_step_1"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#orig_steps #view_inbound_step_1"), "Open");
        this.assertLinkPresentWithSubString("view_inbound_step_1", "ViewWorkflowStep.jspa");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".workflow-current-context .workflow-transition-lozenge"), "resolveitsomemore");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_step_2"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_step_2"), "Resolved");
        this.assertLinkPresentWithSubString("view_outbound_step_2", "ViewWorkflowStep.jspa");
        this.clickLink("edit_transition");
        this.setFormElement("transitionName", "resolveitalittleless");
        this.submit("Update");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#orig_steps #view_inbound_step_1"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#orig_steps #view_inbound_step_1"), "Open");
        this.assertLinkPresentWithSubString("view_inbound_step_1", "ViewWorkflowStep.jspa");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".workflow-current-context .workflow-transition-lozenge"), "resolveitalittleless");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_step_2"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_step_2"), "Resolved");
        this.assertLinkPresentWithSubString("view_outbound_step_2", "ViewWorkflowStep.jspa");
        this.navigation.clickLinkWithExactText("Open");
        this.clickLinkWithText("opensomemore");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#orig_steps #view_inbound_step_1"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#orig_steps #view_inbound_step_1"), "Open");
        this.assertLinkPresentWithSubString("view_inbound_step_1", "ViewWorkflowStep.jspa");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".workflow-current-context .workflow-transition-lozenge"), "opensomemore");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "#dest_steps #view_outbound_step_1"));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#dest_steps #view_outbound_step_1"), "Open");
        this.assertLinkPresentWithSubString("view_outbound_step_1", "ViewWorkflowStep.jspa");
        this.clickLinkWithText("Delete");
        this.assertTextPresent("Delete Workflow Transitions");
        this.assertTextSequence(new String[]{"Confirm that you want to delete", "opensomemore", "transition(s)."});
        this.submit("Delete");
        this.assertTextSequence(new String[]{"Edit Workflow", "Workflow2"});
        this.assertTextNotPresent("opensomemore");
        this.assertLinkPresentWithText("Resolve");
        this.assertLinkPresentWithText("resolveitalittleless");
    }

    public void testValidatorsConditionsAndPostFunctions() {
        this.administration.workflows().goTo().workflowSteps("Workflow2");
        this.clickLink("add_trans_1");
        this.setFormElement("transitionName", "testtransition");
        this.submit("Add");
        this.clickLinkWithText("testtransition");
        this.assertTextPresent("Transition: testtransition");
        this.assertLinkPresentWithText("Validators");
        this.assertLinkPresentWithText("Post Functions");
        this.assertLinkPresentWithText("Add");
        this.tester.clickLinkWithText("Add condition", 0);
        this.assertTextPresent("Add Condition To Transition");
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Only Assignee Condition"), new TextCell("Condition to allow only the assignee to execute a transition.")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Only Reporter Condition"), new TextCell("Condition to allow only the reporter to execute a transition.")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Permission Condition"), new TextCell("Condition to allow only users with a certain permission to execute a transition.")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Sub-Task Blocking Condition"), new TextCell("Condition to block parent issue transition depending on sub-task status.")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("User Is In Group"), new TextCell("Condition to allow only users in a given group to execute a transition.")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("User Is In Group Custom Field"), new TextCell("Condition to allow only users in a custom field-specified group to execute a transition.")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("User Is In Project Role"), new TextCell("Condition to allow only users in a given project role to execute a transition.")});
        this.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:onlyassignee-condition");
        this.submit("Add");
        this.assertTextPresent("Only the <b>assignee</b> of the issue can execute this transition.");
        this.tester.clickLinkWithText("Add condition", 0);
        this.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:isuserinprojectrole-condition");
        this.submit("Add");
        this.assertTextPresent("Add Parameters To Condition");
        this.assertTextPresent("Add required parameters to the Condition.");
        this.selectOption("jira.projectrole.id", "Developers");
        this.submit("Add");
        this.assertTextPresent("Only users in project role <b>Developers</b> can execute this transition.");
        this.assertTextSequence(new String[]{"Switch to OR", "Only the <b>assignee</b> of the issue can execute this transition.", "Only users in project role <b>Developers</b> can execute this transition."});
        this.clickLinkWithText("Switch to OR");
        this.assertTextSequence(new String[]{"Switch to AND", "Only the <b>assignee</b> of the issue can execute this transition.", "Only users in project role <b>Developers</b> can execute this transition."});
        this.clickLinkWithText("Add grouped condition");
        this.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:onlyassignee-condition");
        this.submit("Add");
        this.assertTextSequence(new String[]{"Switch to AND", "Switch to OR", "Only the <b>assignee</b> of the issue can execute this transition.", "Only the <b>assignee</b> of the issue can execute this transition.", "Only users in project role <b>Developers</b> can execute this transition."});
        this.clickLinkWithText("Validators");
        this.clickLinkWithText("Add validator");
        this.assertTextPresent("Add Validator To Transition");
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Permission Validator"), new TextCell("Validates that the user has a permission.")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("User Permission Validator"), new TextCell("Validates that the user has a permission, where the OSWorkflow variable holding the username is configurable. Obsolete.")});
        this.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:permission-validator");
        this.submit("Add");
        this.assertTextPresent("Add Parameters To Validator");
        this.assertTextPresent("Add required parameters to the Validator.");
        this.selectOption("permissionKey", "Assignable User");
        this.submit("Add");
        this.assertTextSequence(new String[]{"Add validator", "The transition requires the following criteria to be valid", "Edit", "Delete", "Only users with <b>Assignable User</b> permission can execute this transition."});
        this.clickLinkWithText("Post Functions");
        this.clickLinkWithText("Add post function");
        this.assertTextPresent("Add Post Function To Transition");
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Assign to Current User"), new TextCell("Assigns the issue to the current user if the current user has the 'Assignable User' permission.")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Assign to Lead Developer"), new TextCell("Assigns the issue to the project/component lead developer")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Assign to Reporter"), new TextCell("Assigns the issue to the reporter")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Update Issue Field"), new TextCell("Updates a simple issue field to a given value.")});
        this.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:assigntocurrentuser-function");
        this.submit("Add");
        this.assertTextSequence(new String[]{"Add post function", "The following will be processed after the transition occurs", "Set issue status to the linked status of the destination workflow step.", "Assign the issue to the current user. Please note that the issue will only be assigned to the current user if the current user has the 'Assignable User' permission.", "Add a comment to an issue if one is entered during a transition.", "Update change history for an issue and store the issue in the database.", "Re-index an issue to keep indexes in sync with the database.", "Fire a", "Generic Event", "event that can be processed by the listeners."});
        this.clickLinkWithText("Move Up");
        this.assertLinkWithTextNotPresent("Can't move up from the top!", "Move Up");
        this.assertTextSequence(new String[]{"Add post function", "The following will be processed after the transition occurs", "Assign the issue to the current user. Please note that the issue will only be assigned to the current user if the current user has the 'Assignable User' permission.", "Set issue status to the linked status of the destination workflow step.", "Add a comment to an issue if one is entered during a transition.", "Update change history for an issue and store the issue in the database.", "Re-index an issue to keep indexes in sync with the database.", "Fire a", "Generic Event", "event that can be processed by the listeners."});
        while (this.tester.getDialog().isLinkPresentWithText("Move Down")) {
            this.clickLinkWithText("Move Down");
        }
        this.assertLinkNotPresentWithText("Move Down");
        this.assertTextSequence(new String[]{"Add post function", "The following will be processed after the transition occurs", "Set issue status to the linked status of the destination workflow step.", "Add a comment to an issue if one is entered during a transition.", "Update change history for an issue and store the issue in the database.", "Re-index an issue to keep indexes in sync with the database.", "Fire a", "Generic Event", "event that can be processed by the listeners.", "Assign the issue to the current user. Please note that the issue will only be assigned to the current user if the current user has the 'Assignable User' permission."});
    }

    private class XsrfLinkCell
    extends LinkCell {
        private XsrfLinkCell(String url, String label) {
            super(TestWorkflowEditor.this.page.addXsrfToken(url), label);
        }
    }
}

