/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestWorkflowEditing
extends JIRAWebTest {
    public TestWorkflowEditing(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.administration.restoreData("editableworkflow.xml");
    }

    public void testSubtaskBlockingConditions() {
        this.administration.workflows().goTo().workflowSteps("Copy of jira");
        this.tester.clickLinkWithText("Close Issue");
        this.tester.clickLinkWithText("Add condition", 0);
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:subtaskblocking-condition");
        this.tester.submit("Add");
        this.tester.checkCheckbox("issue_statuses", "1");
        this.tester.checkCheckbox("issue_statuses", "3");
        this.tester.checkCheckbox("issue_statuses", "4");
        this.tester.submit("Add");
        this.assertTextSequence(new String[]{"All sub-tasks must have one of the following statuses to allow parent issue transitions:", "Open", "In Progress", "or", "Reopened"});
        this.tester.clickLinkWithText("Edit", 3);
        this.tester.checkCheckbox("issue_statuses", "1");
        this.tester.checkCheckbox("issue_statuses", "3");
        this.tester.checkCheckbox("issue_statuses", "4");
        this.tester.checkCheckbox("issue_statuses", "5");
        this.tester.submit("Update");
        this.assertTextSequence(new String[]{"All sub-tasks must have one of the following statuses to allow parent issue transitions:", "Open", "In Progress", "Reopened", "or", "Resolved"});
        this.tester.clickLinkWithText("Delete", 3);
        this.tester.assertTextNotPresent("All sub-tasks must have one of the following statuses to allow parent issue transitions:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWorkflowAddFromXmlNotAvailableToAdmins() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.administration.workflows().goTo();
            TestWorkflowEditing.assertFalse((boolean)this.administration.workflows().isImportWorkflowFromXmlButtonPresent());
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWorkflowAddFromXmlAvailableToSysAdmins() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.workflows().goTo();
            TestWorkflowEditing.assertTrue((boolean)this.administration.workflows().isImportWorkflowFromXmlButtonPresent());
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }
}

