/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.SCHEMES, Category.WORKFLOW})
public class TestWorkFlowSchemes
extends JIRAWebTest {
    private static final String TAB_NAME = "Tab for Testing";
    private static final String CUSTOM_FIELD_NAME = "Approval Rating";
    private static final String CUSTOM_FIELD_NAME_TWO = "Animal";
    String customFieldId;
    String customFieldId2;
    private static final String UNSHOWN_STATUS = "Unshown Status";

    public TestWorkFlowSchemes(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.administration.restoreData("blankWithOldDefault.xml");
    }

    public void testWorkFlowSchemes() {
        this.administration.restoreData("blankWithOldDefault.xml");
        if (this.workflowSchemeExists("New Workflow Scheme")) {
            this.associateWorkFlowSchemeToProject("homosapien", "Default");
            this.waitForSuccessfulWorkflowSchemeMigration("homosapien", "Default");
            this.associateWorkFlowSchemeToProject("monkey", "Default");
            this.waitForSuccessfulWorkflowSchemeMigration("monkey", "Default");
            this.deleteWorkFlowScheme("10000");
        }
        if (this.workflowExists("New Workflow For Testing")) {
            this.deleteWorkFlow("New Workflow For Testing");
        }
        if (this.workflowExists("Copied Workflow")) {
            this.deleteWorkFlow("Copied Workflow");
        }
        if (this.linkedStatusExists("Approved")) {
            this.deleteLinkedStatus("10000");
        }
        this.resetFields();
        this.removeAllFieldScreens();
        this.removeAllCustomFields();
        this.customFieldId = this.addCustomField("textfield", CUSTOM_FIELD_NAME);
        this.customFieldId2 = this.addCustomField("textfield", CUSTOM_FIELD_NAME_TWO);
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", "test 1", "Minor", null, null, null, "Administrator", "test environment 1", "test description for workflow schemes", null, null, null);
        this.addScreen("Test Workflow Screen", "");
        this.addFieldToFieldScreen("Test Workflow Screen", CUSTOM_FIELD_NAME);
        this.addTabToScreen("Test Workflow Screen", TAB_NAME);
        this.addFieldToFieldScreenTab("Test Workflow Screen", TAB_NAME, CUSTOM_FIELD_NAME_TWO, "");
        this.workflowAddScheme();
        this.workflowAddDuplicateScheme();
        this.workflowAddInvalidScheme();
        this.workflowAddWorkflow();
        this.workflowCopyWorkflow();
        this.workflowAddDuplicateWorkflow();
        this.workflowAddInvalidWorkflow();
        this.workflowAddLinkedStatus();
        this.workflowAddDuplicateLinkedStatus();
        this.workflowAddInvalidLinkedStatus();
        this.workflowAddStep();
        this.workflowAddTransition();
        this.workflowAddDuplicateTransition();
        this.workflowAddInvalidTransition();
        this.workflowAssignWorkflowSchemeToIssueType();
        this.workflowAssociateWorkflowSchemeToProject();
        this.workflowPerformAction(issueKey);
        this._testNoActiveStatus();
        this.associateWorkFlowSchemeToProject("homosapien", "Default");
        this.waitForSuccessfulWorkflowSchemeMigration("homosapien", "Default");
        this.workflowDeleteScheme();
        this.workflowDeleteTransition();
        this.workflowDeleteStep();
        this.workflowDeleteLinkedStatus();
        this.workflowDeleteWorkflow();
        this.deleteIssue(issueKey);
        this.removeAllFieldScreens();
        this.removeAllCustomFields();
    }

    public void testJRADEV7692() {
        this.administration.restoreBlankInstance();
        this.workflowAddScheme();
        this.workflowAddWorkflow();
        this.workflowCopyWorkflow();
        this.workflowAssignWorkflowSchemeToIssueType();
        this.addWorkFlowScheme("Scheme7692", "Another tests workflow scheme.");
    }

    private void _testNoActiveStatus() {
        TestWorkFlowSchemes.logSection("Workflow Schemes: Non-active status should not be displayed if it's not active");
        this.addLinkedStatus(UNSHOWN_STATUS, "This status should not be shown in the issue navigator");
        this.tester.assertTextPresent(UNSHOWN_STATUS);
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Approved");
        this.tester.assertTextNotPresent(UNSHOWN_STATUS);
        this.deleteLinkedStatus("10001");
        this.tester.assertTextNotPresent(UNSHOWN_STATUS);
    }

    public void workflowAddScheme() {
        TestWorkFlowSchemes.log("Workflow Schemes: Create a workflow scheme");
        this.addWorkFlowScheme("New Workflow Scheme", "New workflow scheme for testing");
        this.tester.assertTextPresent("Workflow Schemes");
    }

    public void workflowDeleteScheme() {
        TestWorkFlowSchemes.log("Workflow Schemes: Delete a workflow scheme");
        this.deleteWorkFlowScheme("10000");
        this.tester.assertTextPresent("Workflow Schemes");
        this.tester.assertTextNotPresent("New Workflow Scheme");
    }

    public void workflowAddDuplicateScheme() {
        TestWorkFlowSchemes.log("Workflow Schemes: Add a workflow scheme with a duplicate name");
        this.addWorkFlowScheme("New Workflow Scheme", "");
        this.tester.assertTextPresent("Add Workflow Scheme");
        this.tester.assertTextPresent("A Scheme with this name already exists.");
    }

    public void workflowAddInvalidScheme() {
        TestWorkFlowSchemes.log("Workflow Schemes: Add a workflow scheme with a invalid name");
        this.addWorkFlowScheme("", "");
        this.tester.assertTextPresent("Add Workflow Scheme");
        this.tester.assertTextPresent("Please specify a name for this Scheme.");
    }

    public void workflowAddWorkflow() {
        TestWorkFlowSchemes.log("Workflow Schemes: Create a workflow");
        this.addWorkFlow("New Workflow For Testing", "New workflow for testing");
        this.gotoWorkFlow();
        this.tester.assertTextPresent("New Workflow For Testing");
    }

    public void workflowDeleteWorkflow() {
        TestWorkFlowSchemes.log("Workflow Schemes: Delete a workflow");
        this.deleteWorkFlow("New Workflow For Testing");
        this.tester.assertTextNotPresent("New Workflow For Testing");
        this.deleteWorkFlow("Copied Workflow");
        this.tester.assertTextNotPresent("Copied Workflow");
    }

    public void workflowCopyWorkflow() {
        TestWorkFlowSchemes.log("Workflow Schemes: Copy a workflow");
        this.copyWorkFlow("jira", "Copied Workflow", "Workflow copied from JIRA default");
        this.tester.assertTextPresent("Copied Workflow");
    }

    public void workflowAddDuplicateWorkflow() {
        TestWorkFlowSchemes.log("Workflow Schemes: Add a workflow with a duplicate name");
        this.addWorkFlow("Copied Workflow", "");
        this.tester.assertTextPresent("A workflow with this name already exists.");
    }

    public void workflowAddInvalidWorkflow() {
        TestWorkFlowSchemes.log("Workflow Schemes: Add a workflow with an invalid name");
        this.addWorkFlow("", "");
        this.tester.assertTextPresent("You must specify a workflow name.");
    }

    public void workflowAddLinkedStatus() {
        TestWorkFlowSchemes.log("Workflow Schemes: Add a linked status");
        this.addLinkedStatus("Approved", "The resolution of this issue has been approved");
        this.tester.assertTextPresent("Approved");
    }

    public void workflowDeleteLinkedStatus() {
        TestWorkFlowSchemes.log("Workflow Schemes: Delete a linked status");
        this.deleteLinkedStatus("10000");
        this.tester.assertTextNotPresent("Approved");
    }

    public void workflowAddDuplicateLinkedStatus() {
        TestWorkFlowSchemes.log("Workflow Scheme: Add a linked status with a duplicate name");
        this.addLinkedStatus("Approved", "");
        this.tester.assertTextPresent("A status with that name already exists, please enter a different name.");
    }

    public void workflowAddInvalidLinkedStatus() {
        TestWorkFlowSchemes.log("Workflow Scheme: Add a linked status with a invalid name");
        this.addLinkedStatus("", "");
        this.tester.assertTextPresent("You must specify a name.");
    }

    public void workflowAddStep() {
        TestWorkFlowSchemes.log("Workflow Scheme: Add a step");
        this.administration.workflows().goTo().workflowSteps("Copied Workflow").add("Approved", "Approved");
        this.tester.assertLinkPresentWithText("Approved");
        this.tester.assertFormElementNotPresent("stepName");
        this.tester.assertFormElementNotPresent("stepStatus");
    }

    public void workflowDeleteStep() {
        TestWorkFlowSchemes.log("Workflow Scheme: delete a step");
        this.deleteStep("Copied Workflow", "Approved");
        this.tester.assertLinkNotPresent("Approved");
        this.tester.assertFormElementPresent("stepName");
        this.tester.assertFormElementPresent("stepStatus");
    }

    public void workflowAddTransition() {
        TestWorkFlowSchemes.log("Workflow Scheme: Add a transition to a step");
        this.addTransition("Copied Workflow", "Resolved", "Approve Issue", "", "Approved", "Test Workflow Screen");
        this.tester.assertLinkPresentWithText("Approve Issue");
        this.addTransition("Copied Workflow", "Approved", "Reopen Issue", "", "Open", "Workflow Screen");
        this.addTransition("Copied Workflow", "Approved", "Close Issue", "", "Closed", null);
    }

    public void workflowDeleteTransition() {
        TestWorkFlowSchemes.log("Workflow Scheme: Delete a transition from a Step");
        this.deleteTransition("Copied Workflow", "Resolved", "Approve Issue");
        this.tester.assertLinkNotPresentWithText("Approve Issue");
        this.deleteTransition("Copied Workflow", "Approved", "Reopen Issue");
        this.deleteTransition("Copied Workflow", "Approved", "Close Issue");
    }

    public void workflowAddDuplicateTransition() {
        TestWorkFlowSchemes.log("Workflow Scheme: Add a transition with a duplicate nane");
        this.addTransition("Copied Workflow", "Approved", "Reopen Issue", "", "Open", null);
        this.tester.assertTextPresent("Add Workflow Transition");
        this.tester.assertTextPresent("Transition with this name already exists for Approved step.");
    }

    public void workflowAddInvalidTransition() {
        TestWorkFlowSchemes.log("Workflow Scheme: Add a transition with an invalid name");
        this.addTransition("Copied Workflow", "Approved", "", "", "Open", null);
        this.tester.assertTextPresent("Add Workflow Transition");
        this.tester.assertTextPresent("You must enter a valid name.");
    }

    public void workflowAssignWorkflowSchemeToIssueType() {
        TestWorkFlowSchemes.log("Workflow Scheme: Assign a workflow scheme to an issue type");
        this.assignWorkflowScheme(10000L, "Bug", "Copied Workflow");
    }

    public void workflowActivateWorkflow() {
        this.activateWorkflow("Copied Workflow");
        this.waitForSuccessfulWorkflowActivation("Copied Workflow");
        this.tester.assertLinkPresent("activate_jira");
    }

    public void workflowUnassignWorkflowScheme() {
        TestWorkFlowSchemes.log("Workflow Scheme: Unassign a workflow scheme to an issue type");
        this.unassignWorkflowScheme("New Workflow Scheme", "Bug", "Copied Workflow");
        this.tester.assertTextPresent("Assigned Workflows &amp; Issue Types");
        this.tester.assertTextNotPresent("Copied Workflow");
    }

    public void workflowAssociateWorkflowSchemeToProject() {
        TestWorkFlowSchemes.log("Workflow Scheme; Associate a workflow scheme with a project");
        this.associateWorkFlowSchemeToProject("homosapien", "New Workflow Scheme");
        this.waitForSuccessfulWorkflowSchemeMigration("homosapien", "New Workflow Scheme");
    }

    public void workflowPerformAction(String issueKey) {
        TestWorkFlowSchemes.log("Perform workflow actions using the customised workflow/workflow scheme");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLinkWithText("Resolve Issue");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.tester.assertTextPresent("Resolved");
        this.tester.clickLinkWithText("Approve Issue");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.setFormElement("customfield_" + this.customFieldId, "High");
        this.tester.clickLinkWithText(TAB_NAME);
        this.tester.setFormElement("customfield_" + this.customFieldId2, "Whale");
        this.tester.submit("Transition");
        this.tester.assertTextPresent("Approved");
        this.tester.clickLinkWithText("Reopen Issue");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.tester.assertTextPresent("Open");
    }
}

