/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.webtests.JIRAWebTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestExcludeResolutionOnTransitions
extends JIRAWebTest {
    private static final String WORKFLOW_NAME = "Exclude Resolution Workflow";
    private static final String WORKFLOW_DESC = "A workflow where we will exclude resolutions.";
    private static final String OPEN_STEP_NAME = "Open";
    private static final String CLOSED_STEP_NAME = "Closed Step";
    protected Navigation navigation;

    public TestExcludeResolutionOnTransitions(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        FuncTestHelperFactory factory = new FuncTestHelperFactory(this.tester, this.getEnvironmentData());
        this.navigation = factory.getNavigation();
    }

    public void testAddExcludeAttribute() {
        this.getAdministration().restoreData("blankWithOldDefault.xml");
        this._testCreateWorkflowWithResolutionExcludes();
        this._testExcludeResolutionsSingleIssue();
        this._testExcludeResolutionBulkTransition();
    }

    private void _testExcludeResolutionsSingleIssue() {
        this.navigation.issue().createIssue("homosapien", "Bug", "Test Issue");
        this.clickLinkWithText("Close Issue");
        List<String> extraOptions = Collections.emptyList();
        this.assertExcludedOptions(extraOptions);
        this.selectOption("resolution", "Fixed");
        this.submit();
    }

    private void _testCreateWorkflowWithResolutionExcludes() {
        this.assertTextNotPresent(WORKFLOW_NAME);
        this.addWorkFlow(WORKFLOW_NAME, WORKFLOW_DESC);
        this.gotoWorkFlow();
        this.assertTextPresent(WORKFLOW_NAME);
        this.assertTransitionNameNotPresent(CLOSED_STEP_NAME);
        this.administration.workflows().goTo().workflowSteps(WORKFLOW_NAME).add(CLOSED_STEP_NAME, "Closed");
        this.assertTextPresent(CLOSED_STEP_NAME);
        this.assertTransitionNameNotPresent("Close Issue");
        this.addTransition(WORKFLOW_NAME, OPEN_STEP_NAME, "Close Issue", "Close issue", CLOSED_STEP_NAME, "Resolve Issue Screen");
        this.assertTextPresent("Close Issue");
        this.assertTransitionNameNotPresent("Reopen Issue");
        this.addTransition(WORKFLOW_NAME, CLOSED_STEP_NAME, "Reopen Issue", "Reopen issue", OPEN_STEP_NAME, "Workflow Screen");
        this.assertTextPresent("Reopen Issue");
        this.backdoor.workflow().setTransitionProperty(WORKFLOW_NAME, false, 11L, "jira.field.resolution.exclude", "2,4");
        this.addProject("homosapien", "HSP", "admin");
        this.enableWorkflow();
    }

    private void assertTransitionNameNotPresent(String transitionName) {
        Assert.assertThat((Object)this.tester.getDialog().getElement("content").getTextContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)transitionName)));
    }

    private void enableWorkflow() {
        this.addWorkFlowScheme("New Workflow Scheme", "Test workflow scheme.");
        this.assignWorkflowScheme(10000L, "Bug", WORKFLOW_NAME);
        this.associateWorkFlowSchemeToProject("homosapien", "New Workflow Scheme");
        this.waitForSuccessfulWorkflowSchemeMigration("homosapien", "New Workflow Scheme");
    }

    private void assertExcludedOptions(Collection<String> extraOptions) {
        ArrayList<String> options = new ArrayList<String>(extraOptions);
        options.add("1");
        options.add("3");
        options.add("5");
        this.assertOptionValuesEqual("resolution", options.toArray(new String[options.size()]));
        this.assertOptionValueNotPresent("resolution", "Won't Fix");
        this.assertOptionValueNotPresent("resolution", "Incomplete");
    }

    private void _testExcludeResolutionBulkTransition() {
        ArrayList<String> issueKeys = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            issueKeys.add(this.navigation.issue().createIssue("homosapien", "Bug", "Test Issue " + i));
        }
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationExecuteWorfklowTransition();
        this.navigation.workflows().assertStepOperationDetails();
        this.getDialog().setWorkingForm("bulk-transition-details");
        String[] options = this.getDialog().getForm().getOptions("wftransition");
        String[] optionValues = this.getDialog().getForm().getOptionValues("wftransition");
        if (options == null || options.length == 0) {
            TestExcludeResolutionOnTransitions.fail((String)"No options for 'wftransition' element.");
        }
        String closeTransitionOptionValue = null;
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            if (option.indexOf("Close Issue") <= -1) continue;
            closeTransitionOptionValue = optionValues[i];
            break;
        }
        if (closeTransitionOptionValue == null) {
            TestExcludeResolutionOnTransitions.fail((String)"Could not find option for Close Issue transition");
        }
        this.navigation.workflows().chooseWorkflowAction(closeTransitionOptionValue);
        ArrayList<String> extraOptions = new ArrayList<String>();
        extraOptions.add("-1");
        this.assertExcludedOptions(extraOptions);
        this.selectOption("resolution", "Fixed");
        this.navigation.clickOnNext();
        this.assertTableRowsEqual("updatedfields", 1, new String[][]{{"Resolution", "Fixed"}});
        this.navigation.clickOnNext();
        this.waitAndReloadBulkOperationProgressPage();
        for (String issueKey : issueKeys) {
            this.gotoIssue(issueKey);
            this.text.assertTextPresent(new IdLocator(this.tester, "resolution-val"), "Fixed");
        }
    }
}

