/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.workflow.AbstractTestDraftWorkflowSchemeMigration;
import com.atlassian.jira.webtests.ztests.workflow.AbstractTestWorkflowSchemeMigration;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestDraftWorkflowSchemeMultipleProjectsMigration
extends AbstractTestDraftWorkflowSchemeMigration {
    public TestDraftWorkflowSchemeMultipleProjectsMigration(String name) {
        super(name);
    }

    public void testMigrateMultipleProjects() {
        this.getBackdoor().restoreDataFromResource("WorkflowSchemePublishingMultipleMigrationTest.xml");
        this.publishDraft();
        this.assertStandardIssues("TST");
        this.assertStandardIssues("TSTII");
        this.assertSchemeAndNoDraft("Test Project");
        this.assertSchemeAndNoDraft("Test Project II");
        this.assertNoScheme("Copy of Source Workflow Scheme");
        this.assertSchemeIdChanged("Source Workflow Scheme", 10000L);
    }

    public void testWorkflowMigrationHalfMigratedDataInTheFirstProject() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTestBrokenHalfWayMultiple.xml");
        this.publishDraft();
        this.assertIssuesMigratedAndChangeHistory("TST");
        this.assertStandardIssues("TSTII");
        this.assertSchemeAndNoDraft("Test Project");
        this.assertSchemeAndNoDraft("Test Project II");
        this.assertInactiveSchemeExists("Copy of Source Workflow Scheme", "The workflow scheme the project started on (This copy was automatically generated from a draft, as an intermediate scheme for migration)");
        this.assertNoScheme("Copy 2 of Source Workflow Scheme");
        this.assertSchemeIdChanged("Source Workflow Scheme", 10000L);
    }

    public void testWorkflowMigrationWithUnupdatedIssueInTheFirstProject() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTestIssueWithUnupdatedIssueMultiple.xml");
        this.publishDraft();
        this.assertIssuesMigratedAndChangeHistory("TST");
        this.assertStandardIssues("TSTII");
        this.assertSchemeAndNoDraft("Test Project");
        this.assertSchemeAndNoDraft("Test Project II");
        this.assertInactiveSchemeExists("Copy of Source Workflow Scheme", "The workflow scheme the project started on (This copy was automatically generated from a draft, as an intermediate scheme for migration)");
        this.assertNoScheme("Copy 2 of Source Workflow Scheme");
        this.assertSchemeIdChanged("Source Workflow Scheme", 10000L);
    }

    public void testWorkflowMigrationWithUnupdatedWorkflowSchemeInTheFirstProject() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTestUnchangedSchemeMultiple.xml");
        this.publishDraft();
        this.assertIssuesAfterMigrationWithUnupdatedWorkflowScheme();
        this.assertStandardIssues("TSTII");
        this.assertSchemeAndNoDraft("Test Project");
        this.assertSchemeAndNoDraft("Test Project II");
        this.assertInactiveSchemeExists("Copy of Source Workflow Scheme", "The workflow scheme the project started on (This copy was automatically generated from a draft, as an intermediate scheme for migration)");
        this.assertNoScheme("Copy 2 of Source Workflow Scheme");
        this.assertSchemeIdChanged("Source Workflow Scheme", 10000L);
    }

    public void testWorkflowMigrationHalfMigratedDataNewDestinationInTheFirstProject() throws SAXException {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationHalfMigratedDataNewDestinationMultiple.xml");
        this.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep2!default.jspa?draftMigration=true&projectId=10010&schemeId=10000");
        this.assertTextPresent("Step 1 of 2");
        this.assertTextPresent("The current status of each issue needs to be changed so that it is compatible with the new workflows.");
        this.assertTextPresent("Affected issues: 6 of 12");
        this.assertTextPresent("Affected issues: 10 of 20");
        this.assertTextPresent("Affected issues: 2 of 12");
        this.assertMappingAndSelectOptionsForHalfMigratedDataNewDestination();
        this.submit("Associate");
        this.administration.project().waitForWorkflowMigration(1000L, 100);
        this.assertIssuesInHomosapienProjectAfterHalfMigratedDataNewDestination();
        this.checkIssuesInTestIIProjectAfterHalfMigratedDataNewDestination();
        this.checkIssuesInTestProjectAfterHalfMigratedDataNewDestination();
        this.assertScheme("homosapien", "Homosapien Source Scheme", "The original workflow scheme of the Homosapien project", (Map<String, String>)ImmutableMap.of((Object)"Custom Issue Type", (Object)"Homosapien Custom Issue Type Destination", (Object)"Improvement", (Object)"jira"), "Homospien Destination");
        this.assertScheme("Test Project II", "Homosapien Source Scheme", "The original workflow scheme of the Homosapien project", (Map<String, String>)ImmutableMap.of((Object)"Custom Issue Type", (Object)"Homosapien Custom Issue Type Destination", (Object)"Improvement", (Object)"jira"), "Homospien Destination");
        this.assertNoDraft("homosapien");
        this.assertNoDraft("Test Project II");
        this.assertInactiveSchemeExists("Copy of Homosapien Source Scheme", "The original workflow scheme of the Homosapien project (This copy was automatically generated from a draft, as an intermediate scheme for migration)");
        this.assertNoScheme("Copy 2 of Homosapien Source Scheme");
        this.assertSchemeIdChanged("Homosapien Source Scheme", 10010L);
    }

    private void checkIssuesInTestIIProjectAfterHalfMigratedDataNewDestination() {
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 3").addTransitions("Go custom 4").addHistoryItems(TestDraftWorkflowSchemeMultipleProjectsMigration.item("Workflow", "Homosapien Source 1", "Homospien Destination"), TestDraftWorkflowSchemeMultipleProjectsMigration.item("status", "Custom Status 1", "Custom Status 3")).assertIssue(this.getIssue("TSTII-2"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 4").addTransitions("Resolve").addHistoryItems(TestDraftWorkflowSchemeMultipleProjectsMigration.item("Workflow", "Homosapien Source 1", "Homospien Destination"), TestDraftWorkflowSchemeMultipleProjectsMigration.item("status", "Custom Status 2", "Custom Status 4")).assertIssue(this.getIssue("TSTII-3"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("In Progress").addTransitions("Stop Progress", "Close Issue", "Resolve Issue").addHistoryItems(TestDraftWorkflowSchemeMultipleProjectsMigration.item("Workflow", "Homosapien Source 2", "jira"), TestDraftWorkflowSchemeMultipleProjectsMigration.item("status", "Custom Status 1", "In Progress")).assertIssue(this.getIssue("TSTII-10"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Resolved").addTransitions("Close Issue", "Reopen Issue").addHistoryItems(TestDraftWorkflowSchemeMultipleProjectsMigration.item("Workflow", "Homosapien Source 2", "jira"), TestDraftWorkflowSchemeMultipleProjectsMigration.item("status", "Custom Status 3", "Resolved")).assertIssue(this.getIssue("TSTII-11"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 3").addTransitions("Go custom 4").addHistoryItems(TestDraftWorkflowSchemeMultipleProjectsMigration.item("Workflow", "Homosapien Source 1", "Homospien Destination"), TestDraftWorkflowSchemeMultipleProjectsMigration.item("status", "Custom Status 1", "Custom Status 3")).assertIssue(this.getIssue("TSTII-20"), false);
        new AbstractTestWorkflowSchemeMigration.IssueAssertions().status("Custom Status 4").addTransitions("Resolve").addHistoryItems(TestDraftWorkflowSchemeMultipleProjectsMigration.item("Workflow", "Homosapien Source 1", "Homospien Destination"), TestDraftWorkflowSchemeMultipleProjectsMigration.item("status", "Custom Status 2", "Custom Status 4")).assertIssue(this.getIssue("TSTII-21"), false);
    }

    public void testIssueVerifierErrorInOneProject() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTestIssueVerifierMultipleErrorsInTst.xml");
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        Long schemeId = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectKey("TST").getId();
        this.administration.project().publishWorkflowSchemeDraft("Test Project", schemeId, statusMapping, false);
        this.waitForFailedMigration();
        this.assertIssueVerifierErrorMessages("TST");
        this.assertDraft("Test Project");
        this.assertStandardIssues("TSTII");
        this.assertNoDraft("Test Project II");
        this.assertScheme("Test Project", "Source Workflow Scheme", "The workflow scheme the project started on", SOURCE_SCHEME_WORKFLOW_MAPPING, "Source Workflow 1");
        this.assertScheme("Test Project II", "Copy of Source Workflow Scheme", "The workflow scheme the project started on (This copy was automatically generated from a draft, as an intermediate scheme for migration)", DRAFT_WORKFLOW_MAPPING, "Destinatiom Workflow");
        this.assertSchemeId("Source Workflow Scheme", 10000L);
    }

    public void testIssueVerifierErrorInBothProjects() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTestIssueVerifierMultipleErrorsInBoth.xml");
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        Long schemeId = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectKey("TST").getId();
        this.administration.project().publishWorkflowSchemeDraft("Test Project", schemeId, statusMapping, false);
        this.waitForFailedMigration();
        this.assertIssueVerifierErrorMessages("TST");
        this.assertIssueVerifierErrorMessages("TSTII");
        this.assertInactiveSchemeExists("Copy of Source Workflow Scheme", "The workflow scheme the project started on (This copy was automatically generated from a draft, as an intermediate scheme for migration)");
        this.assertDraft("Test Project");
        this.assertDraft("Test Project II");
        this.assertScheme("Test Project", "Source Workflow Scheme", "The workflow scheme the project started on", SOURCE_SCHEME_WORKFLOW_MAPPING, "Source Workflow 1");
        this.assertScheme("Test Project II", "Source Workflow Scheme", "The workflow scheme the project started on", SOURCE_SCHEME_WORKFLOW_MAPPING, "Source Workflow 1");
        this.assertSchemeId("Source Workflow Scheme", 10000L);
    }

    public void testMigrateMultipleProjectsIfNewProjectIsAssociatedWithTheScheme() {
        this.getBackdoor().restoreDataFromResource("WorkflowSchemePublishingMultipleMigrationTest.xml");
        this.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep2!default.jspa?draftMigration=true&projectId=10000&schemeId=10100");
        this.associateNewProjectToScheme(10000L);
        this.submit("Associate");
        this.administration.project().waitForWorkflowMigration(1000L, 100);
        this.assertScheme("Test Project", "Copy of Source Workflow Scheme", "The workflow scheme the project started on (This copy was automatically generated from a draft, as an intermediate scheme for migration)", DRAFT_WORKFLOW_MAPPING, "Destinatiom Workflow");
        this.assertScheme("Test Project II", "Copy of Source Workflow Scheme", "The workflow scheme the project started on (This copy was automatically generated from a draft, as an intermediate scheme for migration)", DRAFT_WORKFLOW_MAPPING, "Destinatiom Workflow");
        this.assertSchemeId("Source Workflow Scheme", 10000L);
    }

    private void associateNewProjectToScheme(long schemeId) {
        this.backdoor.project().addProject("Test Project III", "TSTIII", "admin");
        this.backdoor.project().setWorkflowScheme("TSTIII", schemeId);
    }

    public void testMultiAdminTaskProgressFlowMultipleProjects() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTwoAdminsMultiple.xml");
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        Long schemeId = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectKey("TST").getId();
        this.administration.project().publishWorkflowSchemeDraft("Test Project", schemeId, statusMapping, false);
        this.assertMultiAdminTaskProgressFlow(10000L);
    }

    public void testMultiAdminTaskProgressFlowMultipleProjectsGoToSecondProject() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTwoAdminsMultiple.xml");
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        Long schemeId = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectKey("TST").getId();
        this.administration.project().publishWorkflowSchemeDraft("Test Project", schemeId, statusMapping, false);
        this.assertMultiAdminTaskProgressFlow(10010L);
    }
}

