/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.backdoor.ProjectControlExt;
import com.atlassian.jira.functest.framework.backdoor.WorkflowsControlExt;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.WorkflowSchemesControl;
import com.atlassian.jira.webtests.ztests.workflow.AbstractTestDraftWorkflowSchemeMigration;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestDraftWorkflowSchemeMigration
extends AbstractTestDraftWorkflowSchemeMigration {
    public TestDraftWorkflowSchemeMigration(String name) {
        super(name);
    }

    public void testDrafWorkflowRemovedWhenInactive() {
        String workflowName = "WorkflowWithDraft";
        this.administration.restoreData("blankWithOldDefault.xml");
        WorkflowsControlExt workflowControl = this.getBackdoor().workflow();
        workflowControl.createWorkflow("WorkflowWithDraft");
        WorkflowSchemesControl workflowSchemesControl = this.getBackdoor().workflowSchemes();
        WorkflowSchemeData scheme = workflowSchemesControl.createScheme(new WorkflowSchemeData().setName("WorkflowWithDraft").setMapping("Bug", "WorkflowWithDraft"));
        String projectKey = "TDWC";
        String projectName = "testDrafWorkflowChanged";
        ProjectControlExt projectControl = this.getBackdoor().project();
        projectControl.addProject("testDrafWorkflowChanged", "TDWC", "admin");
        projectControl.setWorkflowScheme("TDWC", scheme.getId());
        workflowControl.createDraftOfWorkflow("WorkflowWithDraft");
        workflowSchemesControl.createDraft(scheme);
        workflowSchemesControl.updateDraftScheme(scheme.getId().longValue(), new WorkflowSchemeData().setMapping("Bug", "jira"));
        Long schemeId = this.getBackdoor().workflowSchemes().getWorkflowSchemeByProjectKey("TDWC").getId();
        this.administration.project().publishWorkflowSchemeDraft("testDrafWorkflowChanged", schemeId, Collections.emptyMap(), true);
        WorkflowsControlExt.Workflow workflow = workflowControl.getWorkflowDetailed("WorkflowWithDraft");
        TestDraftWorkflowSchemeMigration.assertFalse((String)"Workflow should no longer have a draft.", (boolean)workflow.isHasDraft());
        workflow = workflowControl.getWorkflowDetailed("Copy of WorkflowWithDraft");
        TestDraftWorkflowSchemeMigration.assertNotNull((String)"Workflow draft has been made its own scheme?", (Object)workflow);
        TestDraftWorkflowSchemeMigration.assertEquals((String)"Description should be valid.", (String)String.format("(This copy was automatically generated from a draft, when workflow '%s' was made inactive.)", "WorkflowWithDraft"), (String)workflow.getDescription());
    }

    public void testDrafWorkflowRemovedWhenInactiveWithIssues() {
        String workflowName = "WorkflowWithDraft";
        this.administration.restoreData("blankWithOldDefault.xml");
        WorkflowsControlExt workflowControl = this.getBackdoor().workflow();
        workflowControl.createWorkflow("WorkflowWithDraft");
        WorkflowSchemesControl workflowSchemesControl = this.getBackdoor().workflowSchemes();
        WorkflowSchemeData scheme = workflowSchemesControl.createScheme(new WorkflowSchemeData().setName("WorkflowWithDraft").setMapping("Bug", "WorkflowWithDraft"));
        String projectKey = "TDWC";
        String projectName = "testDrafWorkflowChanged";
        ProjectControlExt projectControl = this.getBackdoor().project();
        projectControl.addProject("testDrafWorkflowChanged", "TDWC", "admin");
        projectControl.setWorkflowScheme("TDWC", scheme.getId());
        this.getBackdoor().issues().createIssue("TDWC", "some issue");
        workflowControl.createDraftOfWorkflow("WorkflowWithDraft");
        workflowSchemesControl.createDraft(scheme);
        workflowSchemesControl.updateDraftScheme(scheme.getId().longValue(), new WorkflowSchemeData().setMapping("Bug", "jira"));
        Long schemeId = this.getBackdoor().workflowSchemes().getWorkflowSchemeByProjectKey("TDWC").getId();
        this.administration.project().publishWorkflowSchemeDraft("testDrafWorkflowChanged", schemeId, Collections.emptyMap(), true);
        WorkflowsControlExt.Workflow workflow = workflowControl.getWorkflowDetailed("WorkflowWithDraft");
        TestDraftWorkflowSchemeMigration.assertFalse((String)"Workflow should no longer have a draft.", (boolean)workflow.isHasDraft());
        workflow = workflowControl.getWorkflowDetailed("Copy of WorkflowWithDraft");
        TestDraftWorkflowSchemeMigration.assertNotNull((String)"Workflow draft has been made its own scheme?", (Object)workflow);
        TestDraftWorkflowSchemeMigration.assertEquals((String)"Description should be valid.", (String)String.format("(This copy was automatically generated from a draft, when workflow '%s' was made inactive.)", "WorkflowWithDraft"), (String)workflow.getDescription());
    }

    public void testWorkflowMigration() {
        this.getBackdoor().restoreDataFromResource("WorkflowSchemePublishingMigrationTest.xml");
        this.publishDraft();
        this.assertStandardIssues("TST");
        this.assertSchemeAndNoDraft("Test Project");
    }

    public void testWorkflowMigrationHalfMigratedData() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTestBrokenHalfWayDraft.xml");
        this.publishDraft();
        this.assertIssuesMigratedAndChangeHistory("TST");
        this.assertSchemeAndNoDraft("Test Project");
    }

    public void testWorkflowMigrationWithUnupdatedIssue() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTestIssueWithUnupdatedIssueDraft.xml");
        this.publishDraft();
        this.assertIssuesMigratedAndChangeHistory("TST");
        this.assertSchemeAndNoDraft("Test Project");
    }

    public void testWorkflowMigrationWithUnupdatedWorkflowScheme() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTestUnchangedSchemeDraft.xml");
        this.publishDraft();
        this.assertIssuesAfterMigrationWithUnupdatedWorkflowScheme();
        this.assertSchemeAndNoDraft("Test Project");
    }

    public void testWorkflowMigrationHalfMigratedDataNewDestination() throws SAXException {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationHalfMigratedDataNewDestinationDraft.xml");
        this.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep2!default.jspa?draftMigration=true&projectId=10010&schemeId=10000");
        this.assertTextPresent("Step 1 of 2");
        this.assertTextPresent("The current status of each issue needs to be changed so that it is compatible with the new workflows.");
        this.text.assertTextPresent(this.locator.css("title"), "Publish Workflows");
        this.text.assertTextPresent(this.locator.css("header h2"), "Publish Workflows");
        this.assertTextPresent("Affected issues: 4 of 8");
        this.assertTextPresent("Affected issues: 8 of 16");
        this.assertTextPresent("Affected issues: 2 of 8");
        this.assertMappingAndSelectOptionsForHalfMigratedDataNewDestination();
        this.submit("Associate");
        this.administration.project().waitForWorkflowMigration(1000L, 100);
        this.assertIssuesInHomosapienProjectAfterHalfMigratedDataNewDestination();
        this.checkIssuesInTestProjectAfterHalfMigratedDataNewDestination();
        this.assertScheme("homosapien", "Homosapien Source Scheme", "The original workflow scheme of the Homosapien project", (Map<String, String>)ImmutableMap.of((Object)"Custom Issue Type", (Object)"Homosapien Custom Issue Type Destination", (Object)"Improvement", (Object)"jira"), "Homospien Destination");
        this.assertNoDraft("homosapien");
    }

    public void testIssueVerifierError() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTestIssueVerifierDraft.xml");
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        Long schemeId = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectKey("TST").getId();
        this.administration.project().publishWorkflowSchemeDraft("Test Project", schemeId, statusMapping, false);
        this.waitForFailedMigration();
        this.assertIssueVerifierErrorMessages("TST");
        this.assertDraft("Test Project");
        this.assertScheme("Test Project", "Source Workflow Scheme", "The workflow scheme the project started on", SOURCE_SCHEME_WORKFLOW_MAPPING, "Source Workflow 1");
    }

    public void testMultiAdminTaskProgressFlow() {
        this.getBackdoor().restoreDataFromResource("WorkflowMigrationTwoAdminsDraft.xml");
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        Long schemeId = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectKey("TST").getId();
        this.administration.project().publishWorkflowSchemeDraft("Test Project", schemeId, statusMapping, false);
        this.assertMultiAdminTaskProgressFlow(10000L);
    }
}

